/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object.unreach;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.UnreachDestinationObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.UnreachDestinationObjBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.destination.Ipv6DestinationCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.destination.Ipv6DestinationCaseBuilder;

public final class PCEPIpv6UnreachDestinationParser
extends CommonObjectParser {
    private static final int CLASS = 28;
    private static final int TYPE = 2;

    public PCEPIpv6UnreachDestinationParser() {
        super(28, 2);
    }

    public static void serializeObject(Boolean processing, Boolean ignore, Ipv6DestinationCase ipv6Case, ByteBuf buffer) {
        List<Ipv6AddressNoZone> dest = ipv6Case.getDestinationIpv6Address();
        Preconditions.checkArgument(dest != null, "Destinationipv6Address is mandatory.");
        ByteBuf body = Unpooled.buffer(16 * dest.size());
        dest.forEach(ipv6 -> ByteBufWriteUtil.writeIpv6Address(ipv6, body));
        ObjectUtil.formatSubobject(2, 28, processing, ignore, body, buffer);
    }

    @Override
    public UnreachDestinationObj parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        UnreachDestinationObjBuilder builder = new UnreachDestinationObjBuilder();
        if (bytes.readableBytes() % 16 != 0) {
            throw new PCEPDeserializerException("Wrong length of array of bytes.");
        }
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        ArrayList<Ipv6AddressNoZone> dest = new ArrayList<Ipv6AddressNoZone>();
        while (bytes.isReadable()) {
            dest.add(Ipv6Util.noZoneAddressForByteBuf(bytes));
        }
        builder.setDestination(new Ipv6DestinationCaseBuilder().setDestinationIpv6Address(dest).build());
        return builder.build();
    }
}

