/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.req.missing.tlv.ReqMissing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.req.missing.tlv.ReqMissingBuilder;

public class ReqMissingTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 3;

    @Override
    public ReqMissing parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        return new ReqMissingBuilder().setRequestId(new RequestId(buffer.readUnsignedInt())).build();
    }

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof ReqMissing, "ReqMissingTlv is mandatory.");
        ReqMissing req = (ReqMissing)tlv;
        ByteBuf body = Unpooled.buffer();
        Preconditions.checkArgument(req.getRequestId() != null, "RequestId is mandatory.");
        ByteBufWriteUtil.writeUnsignedInt(req.getRequestId().getValue(), body);
        TlvUtil.formatTlv(3, body, buffer);
    }
}

