/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.pcc.mock;

import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.protocol.pcep.pcc.mock.api.PCCSession;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.Stateful1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.Tlvs3;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.lsp.db.version.tlv.LspDbVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.Tlvs1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.Tlvs;

final class PCCSyncOptimization {
    private final boolean dbVersionMatch;
    private final boolean isSyncAvoidanceEnabled;
    private final boolean isDeltaSyncEnabled;
    private final boolean isTriggeredInitialSynEnable;
    private final boolean isTriggeredReSyncEnable;
    private final LspDbVersion localLspDbVersion;
    private final LspDbVersion remoteLspDbVersion;
    private BigInteger lspDBVersion = BigInteger.ONE;
    private Boolean resynchronizing = Boolean.FALSE;

    PCCSyncOptimization(@Nonnull PCCSession session) {
        Objects.requireNonNull(session);
        Tlvs remote = session.getRemoteTlvs();
        Tlvs local = session.localSessionCharacteristics();
        this.localLspDbVersion = PCCSyncOptimization.getLspDbVersion(local);
        this.remoteLspDbVersion = PCCSyncOptimization.getLspDbVersion(remote);
        this.dbVersionMatch = PCCSyncOptimization.compareLspDbVersion(this.localLspDbVersion, this.remoteLspDbVersion);
        this.isSyncAvoidanceEnabled = PCCSyncOptimization.isSyncAvoidance(local) && PCCSyncOptimization.isSyncAvoidance(remote);
        this.isDeltaSyncEnabled = PCCSyncOptimization.isDeltaSync(local) && PCCSyncOptimization.isDeltaSync(remote);
        this.isTriggeredInitialSynEnable = PCCSyncOptimization.isTriggeredInitialSync(local) && PCCSyncOptimization.isTriggeredInitialSync(remote) && (this.isDeltaSyncEnabled || this.isSyncAvoidanceEnabled);
        this.isTriggeredReSyncEnable = PCCSyncOptimization.isTriggeredReSync(local) && PCCSyncOptimization.isTriggeredReSync(remote);
    }

    public boolean doesLspDbMatch() {
        return this.dbVersionMatch;
    }

    public boolean isSyncAvoidanceEnabled() {
        return this.isSyncAvoidanceEnabled;
    }

    public boolean isDeltaSyncEnabled() {
        return this.isDeltaSyncEnabled;
    }

    public boolean isTriggeredInitSyncEnabled() {
        return this.isTriggeredInitialSynEnable;
    }

    public boolean isTriggeredReSyncEnabled() {
        return this.isTriggeredReSyncEnable;
    }

    public BigInteger getLocalLspDbVersionValue() {
        if (this.localLspDbVersion == null) {
            return null;
        }
        return this.localLspDbVersion.getLspDbVersionValue();
    }

    public BigInteger getRemoteLspDbVersionValue() {
        if (this.remoteLspDbVersion == null) {
            return BigInteger.ONE;
        }
        return this.remoteLspDbVersion.getLspDbVersionValue();
    }

    private static LspDbVersion getLspDbVersion(Tlvs openTlvs) {
        Tlvs3 tlvs3;
        if (openTlvs != null && (tlvs3 = openTlvs.augmentation(Tlvs3.class)) != null && tlvs3.getLspDbVersion() != null && tlvs3.getLspDbVersion().getLspDbVersionValue() != null) {
            return tlvs3.getLspDbVersion();
        }
        return null;
    }

    private static boolean compareLspDbVersion(LspDbVersion local, LspDbVersion remote) {
        if (local != null && remote != null) {
            return local.equals(remote);
        }
        return false;
    }

    private static Stateful1 getStateful1(Tlvs openTlvs) {
        Tlvs1 tlvs1;
        if (openTlvs != null && (tlvs1 = openTlvs.augmentation(Tlvs1.class)) != null && tlvs1.getStateful() != null) {
            return tlvs1.getStateful().augmentation(Stateful1.class);
        }
        return null;
    }

    private static boolean isSyncAvoidance(Tlvs openTlvs) {
        Stateful1 stateful1 = PCCSyncOptimization.getStateful1(openTlvs);
        if (stateful1 != null && stateful1.isIncludeDbVersion() != null) {
            return stateful1.isIncludeDbVersion();
        }
        return false;
    }

    private static boolean isDeltaSync(Tlvs openTlvs) {
        Stateful1 stateful1 = PCCSyncOptimization.getStateful1(openTlvs);
        if (stateful1 != null && stateful1.isDeltaLspSyncCapability() != null) {
            return stateful1.isDeltaLspSyncCapability();
        }
        return false;
    }

    private static boolean isTriggeredInitialSync(Tlvs openTlvs) {
        Stateful1 stateful1 = PCCSyncOptimization.getStateful1(openTlvs);
        if (stateful1 != null && stateful1.isTriggeredInitialSync() != null) {
            return stateful1.isTriggeredInitialSync();
        }
        return false;
    }

    private static boolean isTriggeredReSync(Tlvs openTlvs) {
        Stateful1 stateful1 = PCCSyncOptimization.getStateful1(openTlvs);
        if (stateful1 != null && stateful1.isTriggeredResync() != null) {
            return stateful1.isTriggeredResync();
        }
        return false;
    }

    public Optional<BigInteger> incrementLspDBVersion() {
        if (!this.isSyncAvoidanceEnabled()) {
            return Optional.empty();
        }
        if (this.isSyncNeedIt() && this.getLocalLspDbVersionValue() != null && !this.resynchronizing.booleanValue()) {
            this.lspDBVersion = this.getLocalLspDbVersionValue();
            return Optional.of(this.lspDBVersion);
        }
        if (this.resynchronizing.booleanValue()) {
            return Optional.of(this.lspDBVersion);
        }
        this.lspDBVersion = this.lspDBVersion.add(BigInteger.ONE);
        return Optional.of(this.lspDBVersion);
    }

    public boolean isSyncNeedIt() {
        return !this.doesLspDbMatch() || this.resynchronizing != false;
    }

    public void setResynchronizingState(Boolean resync) {
        this.resynchronizing = resync;
    }
}

