/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.pcc.mock;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.protocol.pcep.pcc.mock.PCCTunnel;
import org.opendaylight.protocol.pcep.pcc.mock.api.LspType;
import org.opendaylight.protocol.pcep.pcc.mock.spi.MsgBuilderUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.PlspId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.IpPrefixCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder;

final class PCCTunnelBuilder {
    static final int PCC_DELEGATION = -1;
    private static final String ENDPOINT_ADDRESS = "1.1.1.1";
    private static final String ENDPOINT_PREFIX = "1.1.1.1/32";
    private static final Subobject DEFAULT_ENDPOINT_HOP = PCCTunnelBuilder.getDefaultEROEndpointHop();

    private PCCTunnelBuilder() {
        throw new UnsupportedOperationException();
    }

    static Map<PlspId, PCCTunnel> createTunnels(String address, int lsps) {
        HashMap<PlspId, PCCTunnel> tunnels = new HashMap<PlspId, PCCTunnel>();
        for (int i = 1; i <= lsps; ++i) {
            PCCTunnel tunnel = new PCCTunnel(MsgBuilderUtil.getDefaultPathName(address, i), -1, LspType.PCC_LSP, MsgBuilderUtil.createPath(Lists.newArrayList(DEFAULT_ENDPOINT_HOP)));
            tunnels.put(new PlspId(Long.valueOf(i)), tunnel);
        }
        return tunnels;
    }

    private static Subobject getDefaultEROEndpointHop() {
        SubobjectBuilder builder = new SubobjectBuilder();
        builder.setLoose(false);
        builder.setSubobjectType(new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix(ENDPOINT_PREFIX))).build()).build());
        return builder.build();
    }
}

