/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.pcc.mock;

import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.protocol.concepts.KeyMapping;
import org.opendaylight.protocol.pcep.PCEPCapability;
import org.opendaylight.protocol.pcep.PCEPSessionNegotiatorFactory;
import org.opendaylight.protocol.pcep.PCEPSessionProposalFactory;
import org.opendaylight.protocol.pcep.ietf.initiated00.CrabbeInitiatedActivator;
import org.opendaylight.protocol.pcep.ietf.stateful07.StatefulActivator;
import org.opendaylight.protocol.pcep.impl.BasePCEPSessionProposalFactory;
import org.opendaylight.protocol.pcep.impl.DefaultPCEPSessionNegotiatorFactory;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.protocol.pcep.pcc.mock.PCCActivator;
import org.opendaylight.protocol.pcep.pcc.mock.PCCTunnelManagerImpl;
import org.opendaylight.protocol.pcep.pcc.mock.TimerHandler;
import org.opendaylight.protocol.pcep.pcc.mock.api.PCCTunnelManager;
import org.opendaylight.protocol.pcep.pcc.mock.protocol.PCCDispatcherImpl;
import org.opendaylight.protocol.pcep.pcc.mock.protocol.PCCSessionListener;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderContext;
import org.opendaylight.protocol.pcep.spi.pojo.ServiceLoaderPCEPExtensionProviderContext;
import org.opendaylight.protocol.pcep.sync.optimizations.SyncOptimizationsActivator;

final class PCCsBuilder {
    private final int lsps;
    private final boolean pcError;
    private final int pccCount;
    private final InetSocketAddress localAddress;
    private final List<InetSocketAddress> remoteAddress;
    private final short keepAlive;
    private final short deadTimer;
    private final String password;
    private final long reconnectTime;
    private final int redelegationTimeout;
    private final int stateTimeout;
    private final PCEPCapability pcepCapabilities;
    private final Timer timer = new HashedWheelTimer();
    private PCCDispatcherImpl pccDispatcher;

    PCCsBuilder(int lsps, boolean pcError, int pccCount, @Nonnull InetSocketAddress localAddress, @Nonnull List<InetSocketAddress> remoteAddress, short keepAlive, short deadTimer, @Nullable String password, long reconnectTime, int redelegationTimeout, int stateTimeout, @Nonnull PCEPCapability pcepCapabilities) {
        this.lsps = lsps;
        this.pcError = pcError;
        this.pccCount = pccCount;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.keepAlive = keepAlive;
        this.deadTimer = deadTimer;
        this.password = password;
        this.reconnectTime = reconnectTime;
        this.redelegationTimeout = redelegationTimeout;
        this.stateTimeout = stateTimeout;
        this.pcepCapabilities = pcepCapabilities;
        PCCsBuilder.startActivators();
    }

    void createPCCs(BigInteger initialDBVersion, Optional<TimerHandler> timerHandler) {
        InetAddress currentAddress = this.localAddress.getAddress();
        this.pccDispatcher = new PCCDispatcherImpl(ServiceLoaderPCEPExtensionProviderContext.getSingletonInstance().getMessageHandlerRegistry());
        if (timerHandler.isPresent()) {
            timerHandler.get().setPCCDispatcher(this.pccDispatcher);
        }
        for (int i = 0; i < this.pccCount; ++i) {
            PCCTunnelManagerImpl tunnelManager = new PCCTunnelManagerImpl(this.lsps, currentAddress, this.redelegationTimeout, this.stateTimeout, this.timer, timerHandler);
            this.createPCC(new InetSocketAddress(currentAddress, this.localAddress.getPort()), tunnelManager, initialDBVersion);
            currentAddress = InetAddresses.increment(currentAddress);
        }
    }

    private void createPCC(@Nonnull InetSocketAddress plocalAddress, PCCTunnelManager tunnelManager, BigInteger initialDBVersion) {
        PCEPSessionNegotiatorFactory<PCEPSessionImpl> snf = this.getSessionNegotiatorFactory();
        for (InetSocketAddress pceAddress : this.remoteAddress) {
            this.pccDispatcher.createClient(pceAddress, this.reconnectTime, () -> new PCCSessionListener(this.remoteAddress.indexOf(pceAddress), tunnelManager, this.pcError), snf, KeyMapping.getKeyMapping(pceAddress.getAddress(), this.password), plocalAddress, initialDBVersion);
        }
    }

    private PCEPSessionNegotiatorFactory<PCEPSessionImpl> getSessionNegotiatorFactory() {
        ArrayList<PCEPCapability> capabilities = Lists.newArrayList(this.pcepCapabilities);
        return new DefaultPCEPSessionNegotiatorFactory((PCEPSessionProposalFactory)new BasePCEPSessionProposalFactory(this.deadTimer, this.keepAlive, capabilities), 0);
    }

    private static void startActivators() {
        PCCActivator pccActivator = new PCCActivator();
        StatefulActivator stateful = new StatefulActivator();
        SyncOptimizationsActivator optimizationsActivator = new SyncOptimizationsActivator();
        CrabbeInitiatedActivator activator = new CrabbeInitiatedActivator();
        PCEPExtensionProviderContext ctx = ServiceLoaderPCEPExtensionProviderContext.getSingletonInstance();
        pccActivator.start(ctx);
        stateful.start(ctx);
        optimizationsActivator.start(ctx);
        activator.start(ctx);
    }
}

