/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.pcc.mock.protocol;

import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opendaylight.protocol.pcep.PCEPPeerProposal;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.Tlvs3;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.Tlvs3Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.lsp.db.version.tlv.LspDbVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.lsp.db.version.tlv.LspDbVersionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.TlvsBuilder;

public final class PCCPeerProposal
implements PCEPPeerProposal {
    private final BigInteger dbVersion;

    public PCCPeerProposal(@Nonnull BigInteger dbVersion) {
        this.dbVersion = dbVersion;
    }

    public PCCPeerProposal() {
        this.dbVersion = null;
    }

    @Override
    public void setPeerSpecificProposal(@Nonnull InetSocketAddress address, @Nonnull TlvsBuilder openBuilder) {
        Objects.requireNonNull(address);
        LspDbVersion lspDbVersion = new LspDbVersionBuilder().setLspDbVersionValue(this.dbVersion).build();
        openBuilder.addAugmentation(Tlvs3.class, new Tlvs3Builder().setLspDbVersion(lspDbVersion).build());
    }
}

