/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.pcc.mock.spi;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.Tlvs1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.Tlvs1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.lsp.db.version.tlv.LspDbVersionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.pcinitiate.message.pcinitiate.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.OperationalStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.Pcrpt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.PcrptBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.PlspId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.SrpIdNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.SymbolicPathName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.identifiers.tlv.LspIdentifiersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.identifiers.tlv.lsp.identifiers.address.family.Ipv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.identifiers.tlv.lsp.identifiers.address.family.ipv4._case.Ipv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.object.LspBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.object.lsp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.object.lsp.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcerr.pcerr.message.error.type.StatefulCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcerr.pcerr.message.error.type.stateful._case.StatefulBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcerr.pcerr.message.error.type.stateful._case.stateful.SrpsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcrpt.message.PcrptMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcrpt.message.pcrpt.message.ReportsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcrpt.message.pcrpt.message.reports.Path;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcrpt.message.pcrpt.message.reports.PathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.srp.object.Srp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.srp.object.SrpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.symbolic.path.name.tlv.SymbolicPathNameBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Pcerr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcerrBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.EroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.PcerrMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.ErrorsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Ipv4ExtendedTunnelId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelId;

public final class MsgBuilderUtil {
    private MsgBuilderUtil() {
        throw new UnsupportedOperationException();
    }

    public static Pcrpt createPcRtpMessage(Lsp lsp, Optional<Srp> srp, Path path) {
        PcrptBuilder rptBuilder = new PcrptBuilder();
        PcrptMessageBuilder msgBuilder = new PcrptMessageBuilder();
        ReportsBuilder reportBuilder = new ReportsBuilder();
        reportBuilder.setLsp(lsp);
        reportBuilder.setSrp(srp.orElse(null));
        reportBuilder.setPath(path);
        msgBuilder.setReports(Lists.newArrayList(reportBuilder.build()));
        rptBuilder.setPcrptMessage(msgBuilder.build());
        return rptBuilder.build();
    }

    public static Lsp createLsp(long plspId, boolean sync, Optional<Tlvs> tlvs, boolean isDelegatedLsp, boolean remove) {
        LspBuilder lspBuilder = new LspBuilder();
        lspBuilder.setAdministrative(true);
        lspBuilder.setDelegate(isDelegatedLsp);
        lspBuilder.setIgnore(false);
        lspBuilder.setOperational(OperationalStatus.Up);
        lspBuilder.setPlspId(new PlspId(plspId));
        lspBuilder.setProcessingRule(false);
        lspBuilder.setRemove(remove);
        lspBuilder.setSync(sync);
        lspBuilder.setTlvs(tlvs.orElse(null));
        return lspBuilder.build();
    }

    public static Lsp createLsp(long plspId, boolean sync, Optional<Tlvs> tlvs, boolean isDelegatedLspe) {
        return MsgBuilderUtil.createLsp(plspId, sync, tlvs, isDelegatedLspe, false);
    }

    public static Path createPath(List<Subobject> subobjects) {
        PathBuilder pathBuilder = new PathBuilder();
        pathBuilder.setEro(new EroBuilder().setSubobject(subobjects).build());
        return pathBuilder.build();
    }

    public static Srp createSrp(long srpId) {
        SrpBuilder srpBuilder = new SrpBuilder();
        srpBuilder.setProcessingRule(false);
        srpBuilder.setIgnore(false);
        srpBuilder.setOperationId(new SrpIdNumber(srpId));
        return srpBuilder.build();
    }

    public static Path updToRptPath(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcupd.message.pcupd.message.updates.Path path) {
        PathBuilder pathBuilder = new PathBuilder();
        if (path != null) {
            pathBuilder.fieldsFrom(path);
        }
        return pathBuilder.build();
    }

    public static Path reqToRptPath(Requests request) {
        PathBuilder pathBuilder = new PathBuilder();
        if (request != null) {
            pathBuilder.fieldsFrom(request);
        }
        return pathBuilder.build();
    }

    public static Tlvs createLspTlvs(long lspId, boolean symbolicPathName, String tunnelEndpoint, String tunnelSender, String extendedTunnelAddress, Optional<byte[]> symbolicName) {
        return MsgBuilderUtil.createLspTlvs(lspId, symbolicPathName, tunnelEndpoint, tunnelSender, extendedTunnelAddress, symbolicName, Optional.empty());
    }

    public static Tlvs createLspTlvs(long lspId, boolean symbolicPathName, String tunnelEndpoint, String tunnelSender, String extendedTunnelAddress, Optional<byte[]> symbolicName, Optional<BigInteger> lspDBVersion) {
        TlvsBuilder tlvs = new TlvsBuilder().setLspIdentifiers(new LspIdentifiersBuilder().setLspId(new LspId(lspId)).setAddressFamily(new Ipv4CaseBuilder().setIpv4(new Ipv4Builder().setIpv4TunnelEndpointAddress(new Ipv4AddressNoZone(tunnelEndpoint)).setIpv4TunnelSenderAddress(new Ipv4AddressNoZone(tunnelSender)).setIpv4ExtendedTunnelId(new Ipv4ExtendedTunnelId(extendedTunnelAddress)).build()).build()).setTunnelId(new TunnelId((int)lspId)).build());
        if (symbolicPathName) {
            if (symbolicName.isPresent()) {
                tlvs.setSymbolicPathName(new SymbolicPathNameBuilder().setPathName(new SymbolicPathName(symbolicName.get())).build());
            } else {
                tlvs.setSymbolicPathName(new SymbolicPathNameBuilder().setPathName(new SymbolicPathName(MsgBuilderUtil.getDefaultPathName(tunnelSender, lspId))).build());
            }
        }
        if (lspDBVersion.isPresent()) {
            tlvs.addAugmentation(Tlvs1.class, new Tlvs1Builder().setLspDbVersion(new LspDbVersionBuilder().setLspDbVersionValue(lspDBVersion.get()).build()).build());
        }
        return tlvs.build();
    }

    public static Optional<Tlvs> createLspTlvsEndofSync(@Nonnull BigInteger bigInteger) {
        Tlvs tlvs = new TlvsBuilder().addAugmentation(Tlvs1.class, new Tlvs1Builder().setLspDbVersion(new LspDbVersionBuilder().setLspDbVersionValue(bigInteger).build()).build()).build();
        return Optional.of(tlvs);
    }

    public static Pcerr createErrorMsg(@Nonnull PCEPErrors pcepErrors, long srpId) {
        PcerrMessageBuilder msgBuilder = new PcerrMessageBuilder();
        return new PcerrBuilder().setPcerrMessage(msgBuilder.setErrorType(new StatefulCaseBuilder().setStateful(new StatefulBuilder().setSrps(Lists.newArrayList(new SrpsBuilder().setSrp(new SrpBuilder().setProcessingRule(false).setIgnore(false).setOperationId(new SrpIdNumber(srpId)).build()).build())).build()).build()).setErrors(Collections.singletonList(new ErrorsBuilder().setErrorObject(new ErrorObjectBuilder().setType(pcepErrors.getErrorType()).setValue(pcepErrors.getErrorValue()).build()).build())).build()).build();
    }

    public static byte[] getDefaultPathName(String address, long lspId) {
        return ("pcc_" + address + "_tunnel_" + lspId).getBytes(StandardCharsets.UTF_8);
    }
}

