/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectWithTlvsParser<T>
extends CommonObjectParser
implements ObjectSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractObjectWithTlvsParser.class);
    private final TlvRegistry tlvReg;
    private final VendorInformationTlvRegistry viTlvReg;

    protected AbstractObjectWithTlvsParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg, int objectClass, int objectType) {
        super(objectClass, objectType);
        this.tlvReg = Objects.requireNonNull(tlvReg);
        this.viTlvReg = Objects.requireNonNull(viTlvReg);
    }

    protected final void parseTlvs(T builder, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null, "Array of bytes is mandatory. Can't be null.");
        if (!bytes.isReadable()) {
            return;
        }
        ArrayList<VendorInformationTlv> viTlvs = Lists.newArrayList();
        while (bytes.isReadable()) {
            int type = bytes.readUnsignedShort();
            int length = bytes.readUnsignedShort();
            if (length > bytes.readableBytes()) {
                throw new PCEPDeserializerException("Wrong length specified. Passed: " + length + "; Expected: <= " + bytes.readableBytes() + ".");
            }
            ByteBuf tlvBytes = bytes.readSlice(length);
            LOG.trace("Parsing PCEP TLV : {}", (Object)ByteBufUtil.hexDump(tlvBytes));
            if (VendorInformationUtil.isVendorInformationTlv(type)) {
                EnterpriseNumber enterpriseNumber = new EnterpriseNumber(tlvBytes.readUnsignedInt());
                Optional<VendorInformationTlv> viTlv = this.viTlvReg.parseVendorInformationTlv(enterpriseNumber, tlvBytes);
                if (viTlv.isPresent()) {
                    LOG.trace("Parsed VENDOR-INFORMATION TLV {}.", (Object)viTlv.get());
                    viTlvs.add(viTlv.get());
                }
            } else {
                Tlv tlv = this.tlvReg.parseTlv(type, tlvBytes);
                if (tlv != null) {
                    LOG.trace("Parsed PCEP TLV {}.", (Object)tlv);
                    this.addTlv(builder, tlv);
                }
            }
            bytes.skipBytes(TlvUtil.getPadding(4 + length, 4));
        }
        this.addVendorInformationTlvs(builder, viTlvs);
    }

    protected final void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Objects.requireNonNull(tlv, "PCEP TLV is mandatory.");
        LOG.trace("Serializing PCEP TLV {}", (Object)tlv);
        this.tlvReg.serializeTlv(tlv, buffer);
        LOG.trace("Serialized PCEP TLV : {}.", (Object)ByteBufUtil.hexDump(buffer));
    }

    protected void addTlv(T builder, Tlv tlv) {
    }

    protected abstract void addVendorInformationTlvs(T var1, List<VendorInformationTlv> var2);

    protected final void serializeVendorInformationTlvs(List<VendorInformationTlv> tlvs, ByteBuf buffer) {
        if (tlvs != null) {
            for (VendorInformationTlv tlv : tlvs) {
                LOG.trace("Serializing VENDOR-INFORMATION TLV {}", (Object)tlv);
                this.viTlvReg.serializeVendorInformationTlv(tlv, buffer);
                LOG.trace("Serialized VENDOR-INFORMATION TLV : {}.", (Object)ByteBufUtil.hexDump(buffer));
            }
        }
    }
}

