/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi;

import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.util.BitArray;

public final class ObjectUtil {
    private static final int HEADER_SIZE = 4;
    private static final int FLAGS_SIZE = 4;
    private static final int PROCESSED = 2;
    private static final int IGNORED = 3;

    private ObjectUtil() {
    }

    public static void formatSubobject(int objectType, int objectClass, Boolean processingRule, Boolean ignore, ByteBuf body, ByteBuf out) {
        out.writeByte(objectClass);
        BitArray flags = new BitArray(4);
        flags.set(3, ignore);
        flags.set(2, processingRule);
        byte flagB = flags.toByte();
        int typeByte = objectType << 4 | flagB & 0xFF;
        out.writeByte(typeByte);
        out.writeShort(body.writerIndex() + 4);
        out.writeBytes(body);
    }
}

