/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi;

import io.netty.buffer.ByteBuf;

public final class TlvUtil {
    public static final int HEADER_SIZE = 4;
    public static final int PADDED_TO = 4;

    private TlvUtil() {
    }

    public static void formatTlv(int type, ByteBuf body, ByteBuf out) {
        out.writeShort(type);
        out.writeShort(body.writerIndex());
        out.writeBytes(body);
        out.writeZero(TlvUtil.getPadding(4 + body.writerIndex(), 4));
    }

    public static int getPadding(int length, int padding) {
        return (padding - length % padding) % padding;
    }
}

