/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.protocol.pcep.spi.VendorInformationObjectRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public final class SimpleObjectRegistry
implements ObjectRegistry {
    private final HandlerRegistry<DataContainer, ObjectParser, ObjectSerializer> handlers = new HandlerRegistry();
    private static final int MAX_OBJECT_TYPE = 15;
    private static final int MAX_OBJECT_CLASS = 4;
    private final VendorInformationObjectRegistry viRegistry;

    public SimpleObjectRegistry(VendorInformationObjectRegistry viRegistry) {
        this.viRegistry = viRegistry;
    }

    private static int createKey(int objectClass, int objectType) {
        Preconditions.checkArgument(objectClass >= 0 && objectClass <= 255);
        Preconditions.checkArgument(objectType >= 0 && objectType <= 15);
        return objectClass << 4 | objectType;
    }

    public Registration registerObjectParser(int objectClass, int objectType, ObjectParser parser) {
        Preconditions.checkArgument(objectClass >= 0 && objectClass <= 255, "Illegal object class %s", objectClass);
        Preconditions.checkArgument(objectType >= 0 && objectType <= 15, "Illegal object type %s", objectType);
        return this.handlers.registerParser(SimpleObjectRegistry.createKey(objectClass, objectType), parser);
    }

    public Registration registerObjectSerializer(Class<? extends Object> objClass, ObjectSerializer serializer) {
        return this.handlers.registerSerializer(objClass, serializer);
    }

    @Override
    public Object parseObject(int objectClass, int objectType, ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(objectType >= 0 && objectType <= 65535);
        ObjectParser parser = this.handlers.getParser(SimpleObjectRegistry.createKey(objectClass, objectType));
        if (parser == null) {
            if (!header.isProcessingRule().booleanValue()) {
                return null;
            }
            for (int type = 1; type <= 15; ++type) {
                ObjectParser objParser = this.handlers.getParser(SimpleObjectRegistry.createKey(objectClass, type));
                if (objParser == null) continue;
                return new UnknownObject(PCEPErrors.UNRECOGNIZED_OBJ_TYPE);
            }
            return new UnknownObject(PCEPErrors.UNRECOGNIZED_OBJ_CLASS);
        }
        return parser.parseObject(header, buffer);
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        ObjectSerializer serializer = this.handlers.getSerializer(object.getImplementedInterface());
        if (serializer == null) {
            return;
        }
        serializer.serializeObject(object, buffer);
    }

    @Override
    public Optional<? extends Object> parseVendorInformationObject(EnterpriseNumber enterpriseNumber, ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        return this.viRegistry.parseVendorInformationObject(enterpriseNumber, header, buffer);
    }

    @Override
    public void serializeVendorInformationObject(VendorInformationObject viObject, ByteBuf buffer) {
        this.viRegistry.serializeVendorInformationObject(viObject, buffer);
    }
}

