/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.sync.optimizations;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderContext;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.pcep.spi.pojo.AbstractPCEPExtensionProviderActivator;
import org.opendaylight.protocol.pcep.sync.optimizations.LspDbVersionTlvParser;
import org.opendaylight.protocol.pcep.sync.optimizations.SpeakerEntityIdTlvParser;
import org.opendaylight.protocol.pcep.sync.optimizations.SyncOptimizationsCapabilityTlvParser;
import org.opendaylight.protocol.pcep.sync.optimizations.SyncOptimizationsLspObjectParser;
import org.opendaylight.protocol.pcep.sync.optimizations.SyncOptimizationsOpenObjectParser;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.lsp.db.version.tlv.LspDbVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.speaker.entity.id.tlv.SpeakerEntityId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.stateful.capability.tlv.Stateful;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open;
import org.opendaylight.yangtools.concepts.Registration;

public class SyncOptimizationsActivator
extends AbstractPCEPExtensionProviderActivator {
    protected List<Registration> startImpl(PCEPExtensionProviderContext context) {
        ArrayList<Registration> regs = new ArrayList<Registration>();
        TlvRegistry tlvReg = context.getTlvHandlerRegistry();
        VendorInformationTlvRegistry viTlvReg = context.getVendorInformationTlvRegistry();
        regs.add(context.registerObjectParser(new SyncOptimizationsLspObjectParser(tlvReg, viTlvReg)));
        regs.add(context.registerObjectSerializer(Lsp.class, new SyncOptimizationsLspObjectParser(tlvReg, viTlvReg)));
        regs.add(context.registerObjectParser(new SyncOptimizationsOpenObjectParser(tlvReg, viTlvReg)));
        regs.add(context.registerObjectSerializer(Open.class, new SyncOptimizationsOpenObjectParser(tlvReg, viTlvReg)));
        regs.add(context.registerTlvParser(23, new LspDbVersionTlvParser()));
        regs.add(context.registerTlvSerializer(LspDbVersion.class, new LspDbVersionTlvParser()));
        regs.add(context.registerTlvParser(24, new SpeakerEntityIdTlvParser()));
        regs.add(context.registerTlvSerializer(SpeakerEntityId.class, new SpeakerEntityIdTlvParser()));
        regs.add(context.registerTlvParser(16, new SyncOptimizationsCapabilityTlvParser()));
        regs.add(context.registerTlvSerializer(Stateful.class, new SyncOptimizationsCapabilityTlvParser()));
        return regs;
    }
}

