/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;

public final class Ipv4Util {
    public static final int IP4_LENGTH = 4;
    public static final int IP4_BITS_LENGTH = 32;
    private static final Ipv4Prefix EMPTY_PREFIX = new Ipv4Prefix("0.0.0.0/0");

    private Ipv4Util() {
        throw new UnsupportedOperationException();
    }

    public static Ipv4Address addressForByteBuf(ByteBuf buffer) {
        return (Ipv4Address)IetfInetUtil.INSTANCE.ipv4AddressFor(ByteArray.readBytes(buffer, 4));
    }

    public static Ipv4AddressNoZone noZoneAddressForByteBuf(ByteBuf buffer) {
        return (Ipv4AddressNoZone)IetfInetUtil.INSTANCE.ipv4AddressNoZoneFor(ByteArray.readBytes(buffer, 4));
    }

    public static ByteBuf byteBufForAddress(Ipv4Address ipAddress) {
        return Unpooled.wrappedBuffer(Ipv4Util.bytesForAddress(ipAddress));
    }

    public static byte[] bytesForAddress(Ipv4Address address) {
        return IetfInetUtil.INSTANCE.ipv4AddressBytes(address);
    }

    public static int prefixBitsToBytes(int bits) {
        if (bits % 8 != 0) {
            return bits / 8 + 1;
        }
        return bits / 8;
    }

    public static int getPrefixLengthBytes(String prefix) {
        return Ipv4Util.prefixBitsToBytes(Ipv4Util.getPrefixLength(prefix));
    }

    public static byte[] bytesForPrefix(Ipv4Prefix prefix) {
        return IetfInetUtil.INSTANCE.ipv4PrefixToBytes(prefix);
    }

    public static Ipv4Prefix prefixForBytes(byte[] bytes, int length) {
        Preconditions.checkArgument(length <= bytes.length * 8);
        byte[] tmp = bytes.length != 4 ? Arrays.copyOfRange(bytes, 0, 4) : bytes;
        return (Ipv4Prefix)IetfInetUtil.INSTANCE.ipv4PrefixFor(tmp, length);
    }

    public static Ipv4Prefix prefixForByteBuf(ByteBuf buf) {
        int prefixLength = UnsignedBytes.toInt(buf.readByte());
        return Ipv4Util.prefixForByteBuf(buf, prefixLength);
    }

    public static Ipv4Prefix prefixForByteBuf(ByteBuf buf, int prefixLength) {
        int size = prefixLength / 8 + (prefixLength % 8 == 0 ? 0 : 1);
        int readable = buf.readableBytes();
        Preconditions.checkArgument(size <= readable, "Illegal length of IP prefix: %s/%s", size, readable);
        byte[] bytes = new byte[4];
        buf.readBytes(bytes, 0, size);
        return (Ipv4Prefix)IetfInetUtil.INSTANCE.ipv4PrefixFor(bytes, prefixLength);
    }

    public static List<Ipv4Prefix> prefixListForBytes(byte[] bytes) {
        if (bytes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Ipv4Prefix> list = new ArrayList<Ipv4Prefix>();
        int byteOffset = 0;
        while (byteOffset < bytes.length) {
            int bitLength = UnsignedBytes.toInt(bytes[byteOffset]);
            ++byteOffset;
            if (bitLength == 0) {
                list.add(EMPTY_PREFIX);
                continue;
            }
            list.add((Ipv4Prefix)IetfInetUtil.INSTANCE.ipv4PrefixForShort(bytes, byteOffset, bitLength));
            byteOffset += bitLength / 8;
            if (bitLength % 8 == 0) continue;
            ++byteOffset;
        }
        return list;
    }

    protected static int getPrefixLength(String prefixValue) {
        int sep = prefixValue.indexOf(47);
        return Integer.parseInt(prefixValue.substring(sep + 1, prefixValue.length()));
    }

    public static IpAddress getIpAddress(InetAddress inetAddress) {
        return (IpAddress)IetfInetUtil.INSTANCE.ipAddressFor(inetAddress);
    }

    public static InetSocketAddress toInetSocketAddress(IpAddress ipAddress, PortNumber port) {
        String ipString = Ipv4Util.toStringIP(ipAddress);
        return new InetSocketAddress(InetAddresses.forString(ipString), (int)port.getValue());
    }

    public static String incrementIpv4Address(String ipv4Address) {
        return InetAddresses.increment(InetAddresses.forString(ipv4Address)).getHostAddress();
    }

    public static Ipv4Address incrementIpv4Address(Ipv4Address ipv4Address) {
        return new Ipv4Address(Ipv4Util.incrementIpv4Address(ipv4Address.getValue()));
    }

    public static Ipv4Prefix incrementIpv4Prefix(Ipv4Prefix ipv4Prefix) {
        Map.Entry splitIpv4Prefix = IetfInetUtil.INSTANCE.splitIpv4Prefix(ipv4Prefix);
        return (Ipv4Prefix)IetfInetUtil.INSTANCE.ipv4PrefixFor(Ipv4Util.incrementIpv4Address((Ipv4Address)splitIpv4Prefix.getKey()), (int)splitIpv4Prefix.getValue());
    }

    public static String toStringIP(IpAddress ipAddress) {
        if (ipAddress.getIpv4Address() != null) {
            return ipAddress.getIpv4Address().getValue();
        }
        return ipAddress.getIpv6Address().getValue();
    }
}

