/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;

public final class StatisticsUtil {
    private StatisticsUtil() {
        throw new UnsupportedOperationException();
    }

    public static String formatElapsedTime(long seconds) {
        Preconditions.checkArgument(seconds >= 0L);
        return String.format("%1d:%02d:%02d:%02d", TimeUnit.SECONDS.toDays(seconds), TimeUnit.SECONDS.toHours(seconds) - TimeUnit.DAYS.toHours(TimeUnit.SECONDS.toDays(seconds)), TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.HOURS.toMinutes(TimeUnit.SECONDS.toHours(seconds)), seconds - TimeUnit.MINUTES.toSeconds(TimeUnit.SECONDS.toMinutes(seconds)));
    }

    public static long getCurrentTimestampInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }
}

