/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepSessionConfig;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcepSessionConfigBuilder
implements Builder<PcepSessionConfig> {
    private Integer _deadTimerValue;
    private Integer _keepAliveTimerValue;
    Map<Class<? extends Augmentation<PcepSessionConfig>>, Augmentation<PcepSessionConfig>> augmentation = Collections.emptyMap();

    public PcepSessionConfigBuilder() {
    }

    public PcepSessionConfigBuilder(PcepSessionConfig base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._deadTimerValue = base.getDeadTimerValue();
        this._keepAliveTimerValue = base.getKeepAliveTimerValue();
    }

    public Integer getDeadTimerValue() {
        return this._deadTimerValue;
    }

    public Integer getKeepAliveTimerValue() {
        return this._keepAliveTimerValue;
    }

    public <E$$ extends Augmentation<PcepSessionConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkDeadTimerValueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }

    public PcepSessionConfigBuilder setDeadTimerValue(Integer value) {
        if (value != null) {
            PcepSessionConfigBuilder.checkDeadTimerValueRange(value);
        }
        this._deadTimerValue = value;
        return this;
    }

    private static void checkKeepAliveTimerValueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }

    public PcepSessionConfigBuilder setKeepAliveTimerValue(Integer value) {
        if (value != null) {
            PcepSessionConfigBuilder.checkKeepAliveTimerValueRange(value);
        }
        this._keepAliveTimerValue = value;
        return this;
    }

    public PcepSessionConfigBuilder addAugmentation(Class<? extends Augmentation<PcepSessionConfig>> augmentationType, Augmentation<PcepSessionConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepSessionConfig>>, Augmentation<PcepSessionConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcepSessionConfigBuilder removeAugmentation(Class<? extends Augmentation<PcepSessionConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcepSessionConfig build() {
        return new PcepSessionConfigImpl(this);
    }

    private static final class PcepSessionConfigImpl
    extends AbstractAugmentable<PcepSessionConfig>
    implements PcepSessionConfig {
        private final Integer _deadTimerValue;
        private final Integer _keepAliveTimerValue;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PcepSessionConfigImpl(PcepSessionConfigBuilder base) {
            super(base.augmentation);
            this._deadTimerValue = base.getDeadTimerValue();
            this._keepAliveTimerValue = base.getKeepAliveTimerValue();
        }

        public Class<PcepSessionConfig> getImplementedInterface() {
            return PcepSessionConfig.class;
        }

        @Override
        public Integer getDeadTimerValue() {
            return this._deadTimerValue;
        }

        @Override
        public Integer getKeepAliveTimerValue() {
            return this._keepAliveTimerValue;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._deadTimerValue);
            result = 31 * result + Objects.hashCode(this._keepAliveTimerValue);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcepSessionConfig.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcepSessionConfig other = (PcepSessionConfig)obj;
            if (!Objects.equals(this._deadTimerValue, other.getDeadTimerValue())) {
                return false;
            }
            if (!Objects.equals(this._keepAliveTimerValue, other.getKeepAliveTimerValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcepSessionConfigImpl otherImpl = (PcepSessionConfigImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcepSessionConfig");
            CodeHelpers.appendValue(helper, "_deadTimerValue", this._deadTimerValue);
            CodeHelpers.appendValue(helper, "_keepAliveTimerValue", this._keepAliveTimerValue);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

