/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum StoreType implements Enumeration
{
    JKS(0, "JKS"),
    PKCS12(1, "PKCS12");

    private static final Map<String, StoreType> NAME_MAP;
    private static final Map<Integer, StoreType> VALUE_MAP;
    private final String name;
    private final int value;

    private StoreType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    public static Optional<StoreType> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static StoreType forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder<String, StoreType> nb = ImmutableMap.builder();
        ImmutableMap.Builder<Integer, StoreType> vb = ImmutableMap.builder();
        for (StoreType enumItem : StoreType.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

