/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.LspDbVersionTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.SpeakerEntityIdTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.Tlvs4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.lsp.db.version.tlv.LspDbVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.speaker.entity.id.tlv.SpeakerEntityId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Tlvs4Builder
implements Builder<Tlvs4> {
    private LspDbVersion _lspDbVersion;
    private SpeakerEntityId _speakerEntityId;

    public Tlvs4Builder() {
    }

    public Tlvs4Builder(SpeakerEntityIdTlv arg) {
        this._speakerEntityId = arg.getSpeakerEntityId();
    }

    public Tlvs4Builder(LspDbVersionTlv arg) {
        this._lspDbVersion = arg.getLspDbVersion();
    }

    public Tlvs4Builder(Tlvs4 base) {
        this._lspDbVersion = base.getLspDbVersion();
        this._speakerEntityId = base.getSpeakerEntityId();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SpeakerEntityIdTlv) {
            this._speakerEntityId = ((SpeakerEntityIdTlv)arg).getSpeakerEntityId();
            isValidArg = true;
        }
        if (arg instanceof LspDbVersionTlv) {
            this._lspDbVersion = ((LspDbVersionTlv)arg).getLspDbVersion();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.SpeakerEntityIdTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.LspDbVersionTlv]");
    }

    public LspDbVersion getLspDbVersion() {
        return this._lspDbVersion;
    }

    public SpeakerEntityId getSpeakerEntityId() {
        return this._speakerEntityId;
    }

    public Tlvs4Builder setLspDbVersion(LspDbVersion value) {
        this._lspDbVersion = value;
        return this;
    }

    public Tlvs4Builder setSpeakerEntityId(SpeakerEntityId value) {
        this._speakerEntityId = value;
        return this;
    }

    @Override
    public Tlvs4 build() {
        return new Tlvs4Impl(this);
    }

    private static final class Tlvs4Impl
    implements Tlvs4 {
        private final LspDbVersion _lspDbVersion;
        private final SpeakerEntityId _speakerEntityId;
        private int hash = 0;
        private volatile boolean hashValid = false;

        Tlvs4Impl(Tlvs4Builder base) {
            this._lspDbVersion = base.getLspDbVersion();
            this._speakerEntityId = base.getSpeakerEntityId();
        }

        public Class<Tlvs4> getImplementedInterface() {
            return Tlvs4.class;
        }

        @Override
        public LspDbVersion getLspDbVersion() {
            return this._lspDbVersion;
        }

        @Override
        public SpeakerEntityId getSpeakerEntityId() {
            return this._speakerEntityId;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._lspDbVersion);
            this.hash = result = 31 * result + Objects.hashCode(this._speakerEntityId);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Tlvs4.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Tlvs4 other = (Tlvs4)obj;
            if (!Objects.equals(this._lspDbVersion, other.getLspDbVersion())) {
                return false;
            }
            return Objects.equals(this._speakerEntityId, other.getSpeakerEntityId());
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Tlvs4");
            CodeHelpers.appendValue(helper, "_lspDbVersion", this._lspDbVersion);
            CodeHelpers.appendValue(helper, "_speakerEntityId", this._speakerEntityId);
            return helper.toString();
        }
    }
}

