/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.lsp.db.version.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev181109.lsp.db.version.tlv.LspDbVersion;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LspDbVersionBuilder
implements Builder<LspDbVersion> {
    private BigInteger _lspDbVersionValue;
    Map<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKLSPDBVERSIONVALUERANGE_RANGES;

    public LspDbVersionBuilder() {
    }

    public LspDbVersionBuilder(LspDbVersion base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._lspDbVersionValue = base.getLspDbVersionValue();
    }

    public BigInteger getLspDbVersionValue() {
        return this._lspDbVersionValue;
    }

    public <E$$ extends Augmentation<LspDbVersion>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkLspDbVersionValueRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKLSPDBVERSIONVALUERANGE_RANGES) {
            if (!r.contains(value)) continue;
            return;
        }
        CodeHelpers.throwInvalidRange(CHECKLSPDBVERSIONVALUERANGE_RANGES, (Object)value);
    }

    public LspDbVersionBuilder setLspDbVersionValue(BigInteger value) {
        if (value != null) {
            LspDbVersionBuilder.checkLspDbVersionValueRange(value);
        }
        this._lspDbVersionValue = value;
        return this;
    }

    public LspDbVersionBuilder addAugmentation(Class<? extends Augmentation<LspDbVersion>> augmentationType, Augmentation<LspDbVersion> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LspDbVersionBuilder removeAugmentation(Class<? extends Augmentation<LspDbVersion>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public LspDbVersion build() {
        return new LspDbVersionImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed(BigInteger.ZERO, new BigInteger("18446744073709551615"));
        CHECKLSPDBVERSIONVALUERANGE_RANGES = a;
    }

    private static final class LspDbVersionImpl
    extends AbstractAugmentable<LspDbVersion>
    implements LspDbVersion {
        private final BigInteger _lspDbVersionValue;
        private int hash = 0;
        private volatile boolean hashValid = false;

        LspDbVersionImpl(LspDbVersionBuilder base) {
            super(base.augmentation);
            this._lspDbVersionValue = base.getLspDbVersionValue();
        }

        public Class<LspDbVersion> getImplementedInterface() {
            return LspDbVersion.class;
        }

        @Override
        public BigInteger getLspDbVersionValue() {
            return this._lspDbVersionValue;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._lspDbVersionValue);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LspDbVersion.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LspDbVersion other = (LspDbVersion)obj;
            if (!Objects.equals(this._lspDbVersionValue, other.getLspDbVersionValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LspDbVersionImpl otherImpl = (LspDbVersionImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("LspDbVersion");
            CodeHelpers.appendValue(helper, "_lspDbVersionValue", this._lspDbVersionValue);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

