/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class IsoSystemIdentifier
implements TypeObject,
Serializable {
    private static final long serialVersionUID = 5046538823000041421L;
    private final byte[] _value;

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length == 6) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[6..6]]", value);
    }

    @ConstructorProperties(value={"value"})
    public IsoSystemIdentifier(byte[] _value) {
        if (_value != null) {
            IsoSystemIdentifier.check_valueLength(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = (byte[])_value.clone();
    }

    public IsoSystemIdentifier(IsoSystemIdentifier source) {
        this._value = source._value;
    }

    public static IsoSystemIdentifier getDefaultInstance(String defaultValue) {
        return new IsoSystemIdentifier(Base64.getDecoder().decode(defaultValue));
    }

    public byte[] getValue() {
        return this._value == null ? null : (byte[])this._value.clone();
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IsoSystemIdentifier other = (IsoSystemIdentifier)obj;
        return Arrays.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(IsoSystemIdentifier.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

