/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class MplsLabel
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -800754711005769629L;
    private final Long _value;

    private static void check_valueRange(long value) {
        if (value >= 0L && value <= 1048575L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..1048575]]", value);
    }

    @ConstructorProperties(value={"value"})
    public MplsLabel(Long _value) {
        if (_value != null) {
            MplsLabel.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public MplsLabel(MplsLabel source) {
        this._value = source._value;
    }

    public static MplsLabel getDefaultInstance(String defaultValue) {
        return new MplsLabel(Long.valueOf(defaultValue));
    }

    public Long getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MplsLabel other = (MplsLabel)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(MplsLabel.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

