/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev171025.pcep.config;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev171025.pcep.config.SessionConfig;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SessionConfigBuilder
implements Builder<SessionConfig> {
    private Integer _deadTimerValue;
    private Integer _keepAliveTimerValue;
    private IpAddress _listenAddress;
    private PortNumber _listenPort;
    private Short _rpcTimeout;
    Map<Class<? extends Augmentation<SessionConfig>>, Augmentation<SessionConfig>> augmentation = Collections.emptyMap();

    public SessionConfigBuilder() {
    }

    public SessionConfigBuilder(SessionConfig base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._deadTimerValue = base.getDeadTimerValue();
        this._keepAliveTimerValue = base.getKeepAliveTimerValue();
        this._listenAddress = base.getListenAddress();
        this._listenPort = base.getListenPort();
        this._rpcTimeout = base.getRpcTimeout();
    }

    public Integer getDeadTimerValue() {
        return this._deadTimerValue;
    }

    public Integer getKeepAliveTimerValue() {
        return this._keepAliveTimerValue;
    }

    public IpAddress getListenAddress() {
        return this._listenAddress;
    }

    public PortNumber getListenPort() {
        return this._listenPort;
    }

    public Short getRpcTimeout() {
        return this._rpcTimeout;
    }

    public <E$$ extends Augmentation<SessionConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkDeadTimerValueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }

    public SessionConfigBuilder setDeadTimerValue(Integer value) {
        if (value != null) {
            SessionConfigBuilder.checkDeadTimerValueRange(value);
        }
        this._deadTimerValue = value;
        return this;
    }

    private static void checkKeepAliveTimerValueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }

    public SessionConfigBuilder setKeepAliveTimerValue(Integer value) {
        if (value != null) {
            SessionConfigBuilder.checkKeepAliveTimerValueRange(value);
        }
        this._keepAliveTimerValue = value;
        return this;
    }

    public SessionConfigBuilder setListenAddress(IpAddress value) {
        this._listenAddress = value;
        return this;
    }

    public SessionConfigBuilder setListenPort(PortNumber value) {
        this._listenPort = value;
        return this;
    }

    public SessionConfigBuilder setRpcTimeout(Short value) {
        this._rpcTimeout = value;
        return this;
    }

    public SessionConfigBuilder addAugmentation(Class<? extends Augmentation<SessionConfig>> augmentationType, Augmentation<SessionConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SessionConfig>>, Augmentation<SessionConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SessionConfigBuilder removeAugmentation(Class<? extends Augmentation<SessionConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SessionConfig build() {
        return new SessionConfigImpl(this);
    }

    private static final class SessionConfigImpl
    extends AbstractAugmentable<SessionConfig>
    implements SessionConfig {
        private final Integer _deadTimerValue;
        private final Integer _keepAliveTimerValue;
        private final IpAddress _listenAddress;
        private final PortNumber _listenPort;
        private final Short _rpcTimeout;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SessionConfigImpl(SessionConfigBuilder base) {
            super(base.augmentation);
            this._deadTimerValue = base.getDeadTimerValue();
            this._keepAliveTimerValue = base.getKeepAliveTimerValue();
            this._listenAddress = base.getListenAddress();
            this._listenPort = base.getListenPort();
            this._rpcTimeout = base.getRpcTimeout();
        }

        public Class<SessionConfig> getImplementedInterface() {
            return SessionConfig.class;
        }

        @Override
        public Integer getDeadTimerValue() {
            return this._deadTimerValue;
        }

        @Override
        public Integer getKeepAliveTimerValue() {
            return this._keepAliveTimerValue;
        }

        @Override
        public IpAddress getListenAddress() {
            return this._listenAddress;
        }

        @Override
        public PortNumber getListenPort() {
            return this._listenPort;
        }

        @Override
        public Short getRpcTimeout() {
            return this._rpcTimeout;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._deadTimerValue);
            result = 31 * result + Objects.hashCode(this._keepAliveTimerValue);
            result = 31 * result + Objects.hashCode(this._listenAddress);
            result = 31 * result + Objects.hashCode(this._listenPort);
            result = 31 * result + Objects.hashCode(this._rpcTimeout);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SessionConfig.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SessionConfig other = (SessionConfig)obj;
            if (!Objects.equals(this._deadTimerValue, other.getDeadTimerValue())) {
                return false;
            }
            if (!Objects.equals(this._keepAliveTimerValue, other.getKeepAliveTimerValue())) {
                return false;
            }
            if (!Objects.equals(this._listenAddress, other.getListenAddress())) {
                return false;
            }
            if (!Objects.equals(this._listenPort, other.getListenPort())) {
                return false;
            }
            if (!Objects.equals(this._rpcTimeout, other.getRpcTimeout())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SessionConfigImpl otherImpl = (SessionConfigImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SessionConfig");
            CodeHelpers.appendValue(helper, "_deadTimerValue", this._deadTimerValue);
            CodeHelpers.appendValue(helper, "_keepAliveTimerValue", this._keepAliveTimerValue);
            CodeHelpers.appendValue(helper, "_listenAddress", this._listenAddress);
            CodeHelpers.appendValue(helper, "_listenPort", this._listenPort);
            CodeHelpers.appendValue(helper, "_rpcTimeout", this._rpcTimeout);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

