/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class SrpIdNumber
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -7985654367172602048L;
    private final Long _value;

    private static void check_valueRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFEL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967294]]", value);
    }

    @ConstructorProperties(value={"value"})
    public SrpIdNumber(Long _value) {
        if (_value != null) {
            SrpIdNumber.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public SrpIdNumber(SrpIdNumber source) {
        this._value = source._value;
    }

    public static SrpIdNumber getDefaultInstance(String defaultValue) {
        return new SrpIdNumber(Long.valueOf(defaultValue));
    }

    public Long getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SrpIdNumber other = (SrpIdNumber)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(SrpIdNumber.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

