/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.identifiers.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.identifiers.tlv.LspIdentifiers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.identifiers.tlv.lsp.identifiers.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LspIdentifiersBuilder
implements Builder<LspIdentifiers> {
    private AddressFamily _addressFamily;
    private LspId _lspId;
    private TunnelId _tunnelId;
    Map<Class<? extends Augmentation<LspIdentifiers>>, Augmentation<LspIdentifiers>> augmentation = Collections.emptyMap();

    public LspIdentifiersBuilder() {
    }

    public LspIdentifiersBuilder(LspIdentifiers base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._addressFamily = base.getAddressFamily();
        this._lspId = base.getLspId();
        this._tunnelId = base.getTunnelId();
    }

    public AddressFamily getAddressFamily() {
        return this._addressFamily;
    }

    public LspId getLspId() {
        return this._lspId;
    }

    public TunnelId getTunnelId() {
        return this._tunnelId;
    }

    public <E$$ extends Augmentation<LspIdentifiers>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public LspIdentifiersBuilder setAddressFamily(AddressFamily value) {
        this._addressFamily = value;
        return this;
    }

    public LspIdentifiersBuilder setLspId(LspId value) {
        this._lspId = value;
        return this;
    }

    public LspIdentifiersBuilder setTunnelId(TunnelId value) {
        this._tunnelId = value;
        return this;
    }

    public LspIdentifiersBuilder addAugmentation(Class<? extends Augmentation<LspIdentifiers>> augmentationType, Augmentation<LspIdentifiers> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LspIdentifiers>>, Augmentation<LspIdentifiers>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LspIdentifiersBuilder removeAugmentation(Class<? extends Augmentation<LspIdentifiers>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public LspIdentifiers build() {
        return new LspIdentifiersImpl(this);
    }

    private static final class LspIdentifiersImpl
    extends AbstractAugmentable<LspIdentifiers>
    implements LspIdentifiers {
        private final AddressFamily _addressFamily;
        private final LspId _lspId;
        private final TunnelId _tunnelId;
        private int hash = 0;
        private volatile boolean hashValid = false;

        LspIdentifiersImpl(LspIdentifiersBuilder base) {
            super(base.augmentation);
            this._addressFamily = base.getAddressFamily();
            this._lspId = base.getLspId();
            this._tunnelId = base.getTunnelId();
        }

        public Class<LspIdentifiers> getImplementedInterface() {
            return LspIdentifiers.class;
        }

        @Override
        public AddressFamily getAddressFamily() {
            return this._addressFamily;
        }

        @Override
        public LspId getLspId() {
            return this._lspId;
        }

        @Override
        public TunnelId getTunnelId() {
            return this._tunnelId;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._addressFamily);
            result = 31 * result + Objects.hashCode(this._lspId);
            result = 31 * result + Objects.hashCode(this._tunnelId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LspIdentifiers.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LspIdentifiers other = (LspIdentifiers)obj;
            if (!Objects.equals(this._addressFamily, other.getAddressFamily())) {
                return false;
            }
            if (!Objects.equals(this._lspId, other.getLspId())) {
                return false;
            }
            if (!Objects.equals(this._tunnelId, other.getTunnelId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LspIdentifiersImpl otherImpl = (LspIdentifiersImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("LspIdentifiers");
            CodeHelpers.appendValue(helper, "_addressFamily", this._addressFamily);
            CodeHelpers.appendValue(helper, "_lspId", this._lspId);
            CodeHelpers.appendValue(helper, "_tunnelId", this._tunnelId);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

