/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping.PcepSessionState;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcepSessionStateBuilder
implements Builder<PcepSessionState> {
    private Integer _delegatedLspsCount;
    private LocalPref _localPref;
    private Messages _messages;
    private PeerCapabilities _peerCapabilities;
    private PeerPref _peerPref;
    private String _sessionDuration;
    private Boolean _synchronized;
    Map<Class<? extends Augmentation<PcepSessionState>>, Augmentation<PcepSessionState>> augmentation = Collections.emptyMap();

    public PcepSessionStateBuilder() {
    }

    public PcepSessionStateBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState arg) {
        this._sessionDuration = arg.getSessionDuration();
        this._synchronized = arg.isSynchronized();
        this._peerCapabilities = arg.getPeerCapabilities();
        this._messages = arg.getMessages();
        this._localPref = arg.getLocalPref();
        this._peerPref = arg.getPeerPref();
        this._delegatedLspsCount = arg.getDelegatedLspsCount();
    }

    public PcepSessionStateBuilder(PcepSessionState base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._delegatedLspsCount = base.getDelegatedLspsCount();
        this._localPref = base.getLocalPref();
        this._messages = base.getMessages();
        this._peerCapabilities = base.getPeerCapabilities();
        this._peerPref = base.getPeerPref();
        this._sessionDuration = base.getSessionDuration();
        this._synchronized = base.isSynchronized();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState) {
            this._sessionDuration = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).getSessionDuration();
            this._synchronized = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).isSynchronized();
            this._peerCapabilities = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).getPeerCapabilities();
            this._messages = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).getMessages();
            this._localPref = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).getLocalPref();
            this._peerPref = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).getPeerPref();
            this._delegatedLspsCount = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).getDelegatedLspsCount();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState]");
    }

    public Integer getDelegatedLspsCount() {
        return this._delegatedLspsCount;
    }

    public LocalPref getLocalPref() {
        return this._localPref;
    }

    public Messages getMessages() {
        return this._messages;
    }

    public PeerCapabilities getPeerCapabilities() {
        return this._peerCapabilities;
    }

    public PeerPref getPeerPref() {
        return this._peerPref;
    }

    public String getSessionDuration() {
        return this._sessionDuration;
    }

    public Boolean isSynchronized() {
        return this._synchronized;
    }

    public <E$$ extends Augmentation<PcepSessionState>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkDelegatedLspsCountRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }

    public PcepSessionStateBuilder setDelegatedLspsCount(Integer value) {
        if (value != null) {
            PcepSessionStateBuilder.checkDelegatedLspsCountRange(value);
        }
        this._delegatedLspsCount = value;
        return this;
    }

    public PcepSessionStateBuilder setLocalPref(LocalPref value) {
        this._localPref = value;
        return this;
    }

    public PcepSessionStateBuilder setMessages(Messages value) {
        this._messages = value;
        return this;
    }

    public PcepSessionStateBuilder setPeerCapabilities(PeerCapabilities value) {
        this._peerCapabilities = value;
        return this;
    }

    public PcepSessionStateBuilder setPeerPref(PeerPref value) {
        this._peerPref = value;
        return this;
    }

    public PcepSessionStateBuilder setSessionDuration(String value) {
        this._sessionDuration = value;
        return this;
    }

    public PcepSessionStateBuilder setSynchronized(Boolean value) {
        this._synchronized = value;
        return this;
    }

    public PcepSessionStateBuilder addAugmentation(Class<? extends Augmentation<PcepSessionState>> augmentationType, Augmentation<PcepSessionState> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepSessionState>>, Augmentation<PcepSessionState>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcepSessionStateBuilder removeAugmentation(Class<? extends Augmentation<PcepSessionState>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcepSessionState build() {
        return new PcepSessionStateImpl(this);
    }

    private static final class PcepSessionStateImpl
    extends AbstractAugmentable<PcepSessionState>
    implements PcepSessionState {
        private final Integer _delegatedLspsCount;
        private final LocalPref _localPref;
        private final Messages _messages;
        private final PeerCapabilities _peerCapabilities;
        private final PeerPref _peerPref;
        private final String _sessionDuration;
        private final Boolean _synchronized;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PcepSessionStateImpl(PcepSessionStateBuilder base) {
            super(base.augmentation);
            this._delegatedLspsCount = base.getDelegatedLspsCount();
            this._localPref = base.getLocalPref();
            this._messages = base.getMessages();
            this._peerCapabilities = base.getPeerCapabilities();
            this._peerPref = base.getPeerPref();
            this._sessionDuration = base.getSessionDuration();
            this._synchronized = base.isSynchronized();
        }

        public Class<PcepSessionState> getImplementedInterface() {
            return PcepSessionState.class;
        }

        @Override
        public Integer getDelegatedLspsCount() {
            return this._delegatedLspsCount;
        }

        @Override
        public LocalPref getLocalPref() {
            return this._localPref;
        }

        @Override
        public Messages getMessages() {
            return this._messages;
        }

        @Override
        public PeerCapabilities getPeerCapabilities() {
            return this._peerCapabilities;
        }

        @Override
        public PeerPref getPeerPref() {
            return this._peerPref;
        }

        @Override
        public String getSessionDuration() {
            return this._sessionDuration;
        }

        @Override
        public Boolean isSynchronized() {
            return this._synchronized;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._delegatedLspsCount);
            result = 31 * result + Objects.hashCode(this._localPref);
            result = 31 * result + Objects.hashCode(this._messages);
            result = 31 * result + Objects.hashCode(this._peerCapabilities);
            result = 31 * result + Objects.hashCode(this._peerPref);
            result = 31 * result + Objects.hashCode(this._sessionDuration);
            result = 31 * result + Objects.hashCode(this._synchronized);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcepSessionState.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcepSessionState other = (PcepSessionState)obj;
            if (!Objects.equals(this._delegatedLspsCount, other.getDelegatedLspsCount())) {
                return false;
            }
            if (!Objects.equals(this._localPref, other.getLocalPref())) {
                return false;
            }
            if (!Objects.equals(this._messages, other.getMessages())) {
                return false;
            }
            if (!Objects.equals(this._peerCapabilities, other.getPeerCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._peerPref, other.getPeerPref())) {
                return false;
            }
            if (!Objects.equals(this._sessionDuration, other.getSessionDuration())) {
                return false;
            }
            if (!Objects.equals(this._synchronized, other.isSynchronized())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcepSessionStateImpl otherImpl = (PcepSessionStateImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcepSessionState");
            CodeHelpers.appendValue(helper, "_delegatedLspsCount", this._delegatedLspsCount);
            CodeHelpers.appendValue(helper, "_localPref", this._localPref);
            CodeHelpers.appendValue(helper, "_messages", this._messages);
            CodeHelpers.appendValue(helper, "_peerCapabilities", this._peerCapabilities);
            CodeHelpers.appendValue(helper, "_peerPref", this._peerPref);
            CodeHelpers.appendValue(helper, "_sessionDuration", this._sessionDuration);
            CodeHelpers.appendValue(helper, "_synchronized", this._synchronized);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

