/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class OfId
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -2083231690149851771L;
    private final Integer _value;

    private static void check_valueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }

    @ConstructorProperties(value={"value"})
    public OfId(Integer _value) {
        if (_value != null) {
            OfId.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public OfId(OfId source) {
        this._value = source._value;
    }

    public static OfId getDefaultInstance(String defaultValue) {
        return new OfId(Integer.valueOf(defaultValue));
    }

    public Integer getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OfId other = (OfId)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(OfId.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

