/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class ProtocolVersion
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -7283574556842814269L;
    private final Short _value;

    private static void check_valueRange(short value) {
        if (value >= 1 && value <= 7) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..7]]", value);
    }

    @ConstructorProperties(value={"value"})
    public ProtocolVersion(Short _value) {
        if (_value != null) {
            ProtocolVersion.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public ProtocolVersion(ProtocolVersion source) {
        this._value = source._value;
    }

    public static ProtocolVersion getDefaultInstance(String defaultValue) {
        return new ProtocolVersion(Short.valueOf(defaultValue));
    }

    public Short getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolVersion other = (ProtocolVersion)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(ProtocolVersion.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

