/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsIpv6Source;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case.Ipv6;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Ipv6Builder
implements Builder<Ipv6> {
    private Ipv6AddressNoZone _destinationIpv6Address;
    private Ipv6AddressNoZone _sourceIpv6Address;
    Map<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> augmentation = Collections.emptyMap();

    public Ipv6Builder() {
    }

    public Ipv6Builder(EndpointsIpv6Source arg) {
        this._sourceIpv6Address = arg.getSourceIpv6Address();
    }

    public Ipv6Builder(Ipv6 base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._destinationIpv6Address = base.getDestinationIpv6Address();
        this._sourceIpv6Address = base.getSourceIpv6Address();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EndpointsIpv6Source) {
            this._sourceIpv6Address = ((EndpointsIpv6Source)arg).getSourceIpv6Address();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsIpv6Source]");
    }

    public Ipv6AddressNoZone getDestinationIpv6Address() {
        return this._destinationIpv6Address;
    }

    public Ipv6AddressNoZone getSourceIpv6Address() {
        return this._sourceIpv6Address;
    }

    public <E$$ extends Augmentation<Ipv6>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public Ipv6Builder setDestinationIpv6Address(Ipv6AddressNoZone value) {
        this._destinationIpv6Address = value;
        return this;
    }

    public Ipv6Builder setSourceIpv6Address(Ipv6AddressNoZone value) {
        this._sourceIpv6Address = value;
        return this;
    }

    public Ipv6Builder addAugmentation(Class<? extends Augmentation<Ipv6>> augmentationType, Augmentation<Ipv6> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Ipv6Builder removeAugmentation(Class<? extends Augmentation<Ipv6>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Ipv6 build() {
        return new Ipv6Impl(this);
    }

    private static final class Ipv6Impl
    extends AbstractAugmentable<Ipv6>
    implements Ipv6 {
        private final Ipv6AddressNoZone _destinationIpv6Address;
        private final Ipv6AddressNoZone _sourceIpv6Address;
        private int hash = 0;
        private volatile boolean hashValid = false;

        Ipv6Impl(Ipv6Builder base) {
            super(base.augmentation);
            this._destinationIpv6Address = base.getDestinationIpv6Address();
            this._sourceIpv6Address = base.getSourceIpv6Address();
        }

        public Class<Ipv6> getImplementedInterface() {
            return Ipv6.class;
        }

        @Override
        public Ipv6AddressNoZone getDestinationIpv6Address() {
            return this._destinationIpv6Address;
        }

        @Override
        public Ipv6AddressNoZone getSourceIpv6Address() {
            return this._sourceIpv6Address;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._destinationIpv6Address);
            result = 31 * result + Objects.hashCode(this._sourceIpv6Address);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ipv6.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ipv6 other = (Ipv6)obj;
            if (!Objects.equals(this._destinationIpv6Address, other.getDestinationIpv6Address())) {
                return false;
            }
            if (!Objects.equals(this._sourceIpv6Address, other.getSourceIpv6Address())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Ipv6Impl otherImpl = (Ipv6Impl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Ipv6");
            CodeHelpers.appendValue(helper, "_destinationIpv6Address", this._destinationIpv6Address);
            CodeHelpers.appendValue(helper, "_sourceIpv6Address", this._sourceIpv6Address);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

