/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv4._case;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsIpv4Source;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Ipv4Destinations;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeaves;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeavesLeaf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv4._case.P2mpIpv4;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class P2mpIpv4Builder
implements Builder<P2mpIpv4> {
    private List<Ipv4AddressNoZone> _destinationIpv4Address;
    private P2mpLeaves _p2mpLeaves;
    private Ipv4AddressNoZone _sourceIpv4Address;
    Map<Class<? extends Augmentation<P2mpIpv4>>, Augmentation<P2mpIpv4>> augmentation = Collections.emptyMap();

    public P2mpIpv4Builder() {
    }

    public P2mpIpv4Builder(P2mpLeavesLeaf arg) {
        this._p2mpLeaves = arg.getP2mpLeaves();
    }

    public P2mpIpv4Builder(EndpointsIpv4Source arg) {
        this._sourceIpv4Address = arg.getSourceIpv4Address();
    }

    public P2mpIpv4Builder(Ipv4Destinations arg) {
        this._destinationIpv4Address = arg.getDestinationIpv4Address();
    }

    public P2mpIpv4Builder(P2mpIpv4 base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._destinationIpv4Address = base.getDestinationIpv4Address();
        this._p2mpLeaves = base.getP2mpLeaves();
        this._sourceIpv4Address = base.getSourceIpv4Address();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Ipv4Destinations) {
            this._destinationIpv4Address = ((Ipv4Destinations)arg).getDestinationIpv4Address();
            isValidArg = true;
        }
        if (arg instanceof P2mpLeavesLeaf) {
            this._p2mpLeaves = ((P2mpLeavesLeaf)arg).getP2mpLeaves();
            isValidArg = true;
        }
        if (arg instanceof EndpointsIpv4Source) {
            this._sourceIpv4Address = ((EndpointsIpv4Source)arg).getSourceIpv4Address();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Ipv4Destinations, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeavesLeaf, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsIpv4Source]");
    }

    public List<Ipv4AddressNoZone> getDestinationIpv4Address() {
        return this._destinationIpv4Address;
    }

    public P2mpLeaves getP2mpLeaves() {
        return this._p2mpLeaves;
    }

    public Ipv4AddressNoZone getSourceIpv4Address() {
        return this._sourceIpv4Address;
    }

    public <E$$ extends Augmentation<P2mpIpv4>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public P2mpIpv4Builder setDestinationIpv4Address(List<Ipv4AddressNoZone> values) {
        this._destinationIpv4Address = values;
        return this;
    }

    public P2mpIpv4Builder setP2mpLeaves(P2mpLeaves value) {
        this._p2mpLeaves = value;
        return this;
    }

    public P2mpIpv4Builder setSourceIpv4Address(Ipv4AddressNoZone value) {
        this._sourceIpv4Address = value;
        return this;
    }

    public P2mpIpv4Builder addAugmentation(Class<? extends Augmentation<P2mpIpv4>> augmentationType, Augmentation<P2mpIpv4> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<P2mpIpv4>>, Augmentation<P2mpIpv4>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public P2mpIpv4Builder removeAugmentation(Class<? extends Augmentation<P2mpIpv4>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public P2mpIpv4 build() {
        return new P2mpIpv4Impl(this);
    }

    private static final class P2mpIpv4Impl
    extends AbstractAugmentable<P2mpIpv4>
    implements P2mpIpv4 {
        private final List<Ipv4AddressNoZone> _destinationIpv4Address;
        private final P2mpLeaves _p2mpLeaves;
        private final Ipv4AddressNoZone _sourceIpv4Address;
        private int hash = 0;
        private volatile boolean hashValid = false;

        P2mpIpv4Impl(P2mpIpv4Builder base) {
            super(base.augmentation);
            this._destinationIpv4Address = base.getDestinationIpv4Address();
            this._p2mpLeaves = base.getP2mpLeaves();
            this._sourceIpv4Address = base.getSourceIpv4Address();
        }

        public Class<P2mpIpv4> getImplementedInterface() {
            return P2mpIpv4.class;
        }

        @Override
        public List<Ipv4AddressNoZone> getDestinationIpv4Address() {
            return this._destinationIpv4Address;
        }

        @Override
        public P2mpLeaves getP2mpLeaves() {
            return this._p2mpLeaves;
        }

        @Override
        public Ipv4AddressNoZone getSourceIpv4Address() {
            return this._sourceIpv4Address;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._destinationIpv4Address);
            result = 31 * result + Objects.hashCode(this._p2mpLeaves);
            result = 31 * result + Objects.hashCode(this._sourceIpv4Address);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!P2mpIpv4.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            P2mpIpv4 other = (P2mpIpv4)obj;
            if (!Objects.equals(this._destinationIpv4Address, other.getDestinationIpv4Address())) {
                return false;
            }
            if (!Objects.equals(this._p2mpLeaves, other.getP2mpLeaves())) {
                return false;
            }
            if (!Objects.equals(this._sourceIpv4Address, other.getSourceIpv4Address())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                P2mpIpv4Impl otherImpl = (P2mpIpv4Impl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("P2mpIpv4");
            CodeHelpers.appendValue(helper, "_destinationIpv4Address", this._destinationIpv4Address);
            CodeHelpers.appendValue(helper, "_p2mpLeaves", this._p2mpLeaves);
            CodeHelpers.appendValue(helper, "_sourceIpv4Address", this._sourceIpv4Address);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

