/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.Gc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.gc.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GcBuilder
implements Builder<Gc> {
    private Short _maxHop;
    private Short _maxUtilization;
    private Short _minUtilization;
    private Short _overBookingFactor;
    private Tlvs _tlvs;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<Gc>>, Augmentation<Gc>> augmentation = Collections.emptyMap();

    public GcBuilder() {
    }

    public GcBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public GcBuilder(Gc base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._maxHop = base.getMaxHop();
        this._maxUtilization = base.getMaxUtilization();
        this._minUtilization = base.getMinUtilization();
        this._overBookingFactor = base.getOverBookingFactor();
        this._tlvs = base.getTlvs();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader]");
    }

    public Short getMaxHop() {
        return this._maxHop;
    }

    public Short getMaxUtilization() {
        return this._maxUtilization;
    }

    public Short getMinUtilization() {
        return this._minUtilization;
    }

    public Short getOverBookingFactor() {
        return this._overBookingFactor;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E$$ extends Augmentation<Gc>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkMaxHopRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }

    public GcBuilder setMaxHop(Short value) {
        if (value != null) {
            GcBuilder.checkMaxHopRange(value);
        }
        this._maxHop = value;
        return this;
    }

    private static void checkMaxUtilizationRange(short value) {
        if (value >= 0 && value <= 100) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..100]]", value);
    }

    public GcBuilder setMaxUtilization(Short value) {
        if (value != null) {
            GcBuilder.checkMaxUtilizationRange(value);
        }
        this._maxUtilization = value;
        return this;
    }

    private static void checkMinUtilizationRange(short value) {
        if (value >= 0 && value <= 100) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..100]]", value);
    }

    public GcBuilder setMinUtilization(Short value) {
        if (value != null) {
            GcBuilder.checkMinUtilizationRange(value);
        }
        this._minUtilization = value;
        return this;
    }

    private static void checkOverBookingFactorRange(short value) {
        if (value >= 0 && value <= 100) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..100]]", value);
    }

    public GcBuilder setOverBookingFactor(Short value) {
        if (value != null) {
            GcBuilder.checkOverBookingFactorRange(value);
        }
        this._overBookingFactor = value;
        return this;
    }

    public GcBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public GcBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public GcBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public GcBuilder addAugmentation(Class<? extends Augmentation<Gc>> augmentationType, Augmentation<Gc> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Gc>>, Augmentation<Gc>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public GcBuilder removeAugmentation(Class<? extends Augmentation<Gc>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Gc build() {
        return new GcImpl(this);
    }

    private static final class GcImpl
    extends AbstractAugmentable<Gc>
    implements Gc {
        private final Short _maxHop;
        private final Short _maxUtilization;
        private final Short _minUtilization;
        private final Short _overBookingFactor;
        private final Tlvs _tlvs;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private int hash = 0;
        private volatile boolean hashValid = false;

        GcImpl(GcBuilder base) {
            super(base.augmentation);
            this._maxHop = base.getMaxHop();
            this._maxUtilization = base.getMaxUtilization();
            this._minUtilization = base.getMinUtilization();
            this._overBookingFactor = base.getOverBookingFactor();
            this._tlvs = base.getTlvs();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
        }

        public Class<Gc> getImplementedInterface() {
            return Gc.class;
        }

        @Override
        public Short getMaxHop() {
            return this._maxHop;
        }

        @Override
        public Short getMaxUtilization() {
            return this._maxUtilization;
        }

        @Override
        public Short getMinUtilization() {
            return this._minUtilization;
        }

        @Override
        public Short getOverBookingFactor() {
            return this._overBookingFactor;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._maxHop);
            result = 31 * result + Objects.hashCode(this._maxUtilization);
            result = 31 * result + Objects.hashCode(this._minUtilization);
            result = 31 * result + Objects.hashCode(this._overBookingFactor);
            result = 31 * result + Objects.hashCode(this._tlvs);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Gc.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Gc other = (Gc)obj;
            if (!Objects.equals(this._maxHop, other.getMaxHop())) {
                return false;
            }
            if (!Objects.equals(this._maxUtilization, other.getMaxUtilization())) {
                return false;
            }
            if (!Objects.equals(this._minUtilization, other.getMinUtilization())) {
                return false;
            }
            if (!Objects.equals(this._overBookingFactor, other.getOverBookingFactor())) {
                return false;
            }
            if (!Objects.equals(this._tlvs, other.getTlvs())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GcImpl otherImpl = (GcImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Gc");
            CodeHelpers.appendValue(helper, "_maxHop", this._maxHop);
            CodeHelpers.appendValue(helper, "_maxUtilization", this._maxUtilization);
            CodeHelpers.appendValue(helper, "_minUtilization", this._minUtilization);
            CodeHelpers.appendValue(helper, "_overBookingFactor", this._overBookingFactor);
            CodeHelpers.appendValue(helper, "_tlvs", this._tlvs);
            CodeHelpers.appendValue(helper, "_ignore", this._ignore);
            CodeHelpers.appendValue(helper, "_processingRule", this._processingRule);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

