/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.lspa.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LspaBuilder
implements Builder<Lspa> {
    private AttributeFilter _excludeAny;
    private Short _holdPriority;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private String _sessionName;
    private Short _setupPriority;
    private Tlvs _tlvs;
    private Boolean _ignore;
    private Boolean _labelRecordingDesired;
    private Boolean _localProtectionDesired;
    private Boolean _processingRule;
    private Boolean _seStyleDesired;
    Map<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>> augmentation = Collections.emptyMap();

    public LspaBuilder() {
    }

    public LspaBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public LspaBuilder(TunnelAttributes arg) {
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._labelRecordingDesired = arg.isLabelRecordingDesired();
        this._seStyleDesired = arg.isSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public LspaBuilder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }

    public LspaBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public LspaBuilder(Lspa base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._excludeAny = base.getExcludeAny();
        this._holdPriority = base.getHoldPriority();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
        this._tlvs = base.getTlvs();
        this._ignore = base.isIgnore();
        this._labelRecordingDesired = base.isLabelRecordingDesired();
        this._localProtectionDesired = base.isLocalProtectionDesired();
        this._processingRule = base.isProcessingRule();
        this._seStyleDesired = base.isSeStyleDesired();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof Priority) {
            this._holdPriority = ((Priority)arg).getHoldPriority();
            this._setupPriority = ((Priority)arg).getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters) {
            this._includeAny = ((AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes) {
            this._localProtectionDesired = ((TunnelAttributes)arg).isLocalProtectionDesired();
            this._labelRecordingDesired = ((TunnelAttributes)arg).isLabelRecordingDesired();
            this._seStyleDesired = ((TunnelAttributes)arg).isSeStyleDesired();
            this._sessionName = ((TunnelAttributes)arg).getSessionName();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes]");
    }

    public AttributeFilter getExcludeAny() {
        return this._excludeAny;
    }

    public Short getHoldPriority() {
        return this._holdPriority;
    }

    public AttributeFilter getIncludeAll() {
        return this._includeAll;
    }

    public AttributeFilter getIncludeAny() {
        return this._includeAny;
    }

    public String getSessionName() {
        return this._sessionName;
    }

    public Short getSetupPriority() {
        return this._setupPriority;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isLabelRecordingDesired() {
        return this._labelRecordingDesired;
    }

    public Boolean isLocalProtectionDesired() {
        return this._localProtectionDesired;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public Boolean isSeStyleDesired() {
        return this._seStyleDesired;
    }

    public <E$$ extends Augmentation<Lspa>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public LspaBuilder setExcludeAny(AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }

    private static void checkHoldPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }

    public LspaBuilder setHoldPriority(Short value) {
        if (value != null) {
            LspaBuilder.checkHoldPriorityRange(value);
        }
        this._holdPriority = value;
        return this;
    }

    public LspaBuilder setIncludeAll(AttributeFilter value) {
        this._includeAll = value;
        return this;
    }

    public LspaBuilder setIncludeAny(AttributeFilter value) {
        this._includeAny = value;
        return this;
    }

    public LspaBuilder setSessionName(String value) {
        this._sessionName = value;
        return this;
    }

    private static void checkSetupPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }

    public LspaBuilder setSetupPriority(Short value) {
        if (value != null) {
            LspaBuilder.checkSetupPriorityRange(value);
        }
        this._setupPriority = value;
        return this;
    }

    public LspaBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public LspaBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public LspaBuilder setLabelRecordingDesired(Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }

    public LspaBuilder setLocalProtectionDesired(Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }

    public LspaBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public LspaBuilder setSeStyleDesired(Boolean value) {
        this._seStyleDesired = value;
        return this;
    }

    public LspaBuilder addAugmentation(Class<? extends Augmentation<Lspa>> augmentationType, Augmentation<Lspa> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LspaBuilder removeAugmentation(Class<? extends Augmentation<Lspa>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Lspa build() {
        return new LspaImpl(this);
    }

    private static final class LspaImpl
    extends AbstractAugmentable<Lspa>
    implements Lspa {
        private final AttributeFilter _excludeAny;
        private final Short _holdPriority;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final String _sessionName;
        private final Short _setupPriority;
        private final Tlvs _tlvs;
        private final Boolean _ignore;
        private final Boolean _labelRecordingDesired;
        private final Boolean _localProtectionDesired;
        private final Boolean _processingRule;
        private final Boolean _seStyleDesired;
        private int hash = 0;
        private volatile boolean hashValid = false;

        LspaImpl(LspaBuilder base) {
            super(base.augmentation);
            this._excludeAny = base.getExcludeAny();
            this._holdPriority = base.getHoldPriority();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
            this._tlvs = base.getTlvs();
            this._ignore = base.isIgnore();
            this._labelRecordingDesired = base.isLabelRecordingDesired();
            this._localProtectionDesired = base.isLocalProtectionDesired();
            this._processingRule = base.isProcessingRule();
            this._seStyleDesired = base.isSeStyleDesired();
        }

        public Class<Lspa> getImplementedInterface() {
            return Lspa.class;
        }

        @Override
        public AttributeFilter getExcludeAny() {
            return this._excludeAny;
        }

        @Override
        public Short getHoldPriority() {
            return this._holdPriority;
        }

        @Override
        public AttributeFilter getIncludeAll() {
            return this._includeAll;
        }

        @Override
        public AttributeFilter getIncludeAny() {
            return this._includeAny;
        }

        @Override
        public String getSessionName() {
            return this._sessionName;
        }

        @Override
        public Short getSetupPriority() {
            return this._setupPriority;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isLabelRecordingDesired() {
            return this._labelRecordingDesired;
        }

        @Override
        public Boolean isLocalProtectionDesired() {
            return this._localProtectionDesired;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Boolean isSeStyleDesired() {
            return this._seStyleDesired;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._excludeAny);
            result = 31 * result + Objects.hashCode(this._holdPriority);
            result = 31 * result + Objects.hashCode(this._includeAll);
            result = 31 * result + Objects.hashCode(this._includeAny);
            result = 31 * result + Objects.hashCode(this._sessionName);
            result = 31 * result + Objects.hashCode(this._setupPriority);
            result = 31 * result + Objects.hashCode(this._tlvs);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._labelRecordingDesired);
            result = 31 * result + Objects.hashCode(this._localProtectionDesired);
            result = 31 * result + Objects.hashCode(this._processingRule);
            result = 31 * result + Objects.hashCode(this._seStyleDesired);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Lspa.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Lspa other = (Lspa)obj;
            if (!Objects.equals(this._excludeAny, other.getExcludeAny())) {
                return false;
            }
            if (!Objects.equals(this._holdPriority, other.getHoldPriority())) {
                return false;
            }
            if (!Objects.equals(this._includeAll, other.getIncludeAll())) {
                return false;
            }
            if (!Objects.equals(this._includeAny, other.getIncludeAny())) {
                return false;
            }
            if (!Objects.equals(this._sessionName, other.getSessionName())) {
                return false;
            }
            if (!Objects.equals(this._setupPriority, other.getSetupPriority())) {
                return false;
            }
            if (!Objects.equals(this._tlvs, other.getTlvs())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._labelRecordingDesired, other.isLabelRecordingDesired())) {
                return false;
            }
            if (!Objects.equals(this._localProtectionDesired, other.isLocalProtectionDesired())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (!Objects.equals(this._seStyleDesired, other.isSeStyleDesired())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LspaImpl otherImpl = (LspaImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Lspa");
            CodeHelpers.appendValue(helper, "_excludeAny", this._excludeAny);
            CodeHelpers.appendValue(helper, "_holdPriority", this._holdPriority);
            CodeHelpers.appendValue(helper, "_includeAll", this._includeAll);
            CodeHelpers.appendValue(helper, "_includeAny", this._includeAny);
            CodeHelpers.appendValue(helper, "_sessionName", this._sessionName);
            CodeHelpers.appendValue(helper, "_setupPriority", this._setupPriority);
            CodeHelpers.appendValue(helper, "_tlvs", this._tlvs);
            CodeHelpers.appendValue(helper, "_ignore", this._ignore);
            CodeHelpers.appendValue(helper, "_labelRecordingDesired", this._labelRecordingDesired);
            CodeHelpers.appendValue(helper, "_localProtectionDesired", this._localProtectionDesired);
            CodeHelpers.appendValue(helper, "_processingRule", this._processingRule);
            CodeHelpers.appendValue(helper, "_seStyleDesired", this._seStyleDesired);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

