/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.CNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.c.notification.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CNotificationBuilder
implements Builder<CNotification> {
    private Tlvs _tlvs;
    private Short _type;
    private Short _value;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<CNotification>>, Augmentation<CNotification>> augmentation = Collections.emptyMap();

    public CNotificationBuilder() {
    }

    public CNotificationBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public CNotificationBuilder(CNotification base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._tlvs = base.getTlvs();
        this._type = base.getType();
        this._value = base.getValue();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader]");
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Short getType() {
        return this._type;
    }

    public Short getValue() {
        return this._value;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E$$ extends Augmentation<CNotification>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public CNotificationBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    private static void checkTypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }

    public CNotificationBuilder setType(Short value) {
        if (value != null) {
            CNotificationBuilder.checkTypeRange(value);
        }
        this._type = value;
        return this;
    }

    private static void checkValueRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }

    public CNotificationBuilder setValue(Short value) {
        if (value != null) {
            CNotificationBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    public CNotificationBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public CNotificationBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public CNotificationBuilder addAugmentation(Class<? extends Augmentation<CNotification>> augmentationType, Augmentation<CNotification> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CNotification>>, Augmentation<CNotification>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public CNotificationBuilder removeAugmentation(Class<? extends Augmentation<CNotification>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public CNotification build() {
        return new CNotificationImpl(this);
    }

    private static final class CNotificationImpl
    extends AbstractAugmentable<CNotification>
    implements CNotification {
        private final Tlvs _tlvs;
        private final Short _type;
        private final Short _value;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private int hash = 0;
        private volatile boolean hashValid = false;

        CNotificationImpl(CNotificationBuilder base) {
            super(base.augmentation);
            this._tlvs = base.getTlvs();
            this._type = base.getType();
            this._value = base.getValue();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
        }

        public Class<CNotification> getImplementedInterface() {
            return CNotification.class;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Short getType() {
            return this._type;
        }

        @Override
        public Short getValue() {
            return this._value;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._tlvs);
            result = 31 * result + Objects.hashCode(this._type);
            result = 31 * result + Objects.hashCode(this._value);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CNotification.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CNotification other = (CNotification)obj;
            if (!Objects.equals(this._tlvs, other.getTlvs())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CNotificationImpl otherImpl = (CNotificationImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("CNotification");
            CodeHelpers.appendValue(helper, "_tlvs", this._tlvs);
            CodeHelpers.appendValue(helper, "_type", this._type);
            CodeHelpers.appendValue(helper, "_value", this._value);
            CodeHelpers.appendValue(helper, "_ignore", this._ignore);
            CodeHelpers.appendValue(helper, "_processingRule", this._processingRule);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

