/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.Order;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OrderBuilder
implements Builder<Order> {
    private Long _delete;
    private Long _setup;
    Map<Class<? extends Augmentation<Order>>, Augmentation<Order>> augmentation = Collections.emptyMap();

    public OrderBuilder() {
    }

    public OrderBuilder(Order base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._delete = base.getDelete();
        this._setup = base.getSetup();
    }

    public Long getDelete() {
        return this._delete;
    }

    public Long getSetup() {
        return this._setup;
    }

    public <E$$ extends Augmentation<Order>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkDeleteRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }

    public OrderBuilder setDelete(Long value) {
        if (value != null) {
            OrderBuilder.checkDeleteRange(value);
        }
        this._delete = value;
        return this;
    }

    private static void checkSetupRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }

    public OrderBuilder setSetup(Long value) {
        if (value != null) {
            OrderBuilder.checkSetupRange(value);
        }
        this._setup = value;
        return this;
    }

    public OrderBuilder addAugmentation(Class<? extends Augmentation<Order>> augmentationType, Augmentation<Order> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Order>>, Augmentation<Order>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OrderBuilder removeAugmentation(Class<? extends Augmentation<Order>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Order build() {
        return new OrderImpl(this);
    }

    private static final class OrderImpl
    extends AbstractAugmentable<Order>
    implements Order {
        private final Long _delete;
        private final Long _setup;
        private int hash = 0;
        private volatile boolean hashValid = false;

        OrderImpl(OrderBuilder base) {
            super(base.augmentation);
            this._delete = base.getDelete();
            this._setup = base.getSetup();
        }

        public Class<Order> getImplementedInterface() {
            return Order.class;
        }

        @Override
        public Long getDelete() {
            return this._delete;
        }

        @Override
        public Long getSetup() {
            return this._setup;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._delete);
            result = 31 * result + Objects.hashCode(this._setup);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Order.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Order other = (Order)obj;
            if (!Objects.equals(this._delete, other.getDelete())) {
                return false;
            }
            if (!Objects.equals(this._setup, other.getSetup())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OrderImpl otherImpl = (OrderImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Order");
            CodeHelpers.appendValue(helper, "_delete", this._delete);
            CodeHelpers.appendValue(helper, "_setup", this._setup);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

