/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.duration.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.duration.tlv.OverloadDuration;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OverloadDurationBuilder
implements Builder<OverloadDuration> {
    private Long _duration;
    Map<Class<? extends Augmentation<OverloadDuration>>, Augmentation<OverloadDuration>> augmentation = Collections.emptyMap();

    public OverloadDurationBuilder() {
    }

    public OverloadDurationBuilder(OverloadDuration base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._duration = base.getDuration();
    }

    public Long getDuration() {
        return this._duration;
    }

    public <E$$ extends Augmentation<OverloadDuration>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkDurationRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }

    public OverloadDurationBuilder setDuration(Long value) {
        if (value != null) {
            OverloadDurationBuilder.checkDurationRange(value);
        }
        this._duration = value;
        return this;
    }

    public OverloadDurationBuilder addAugmentation(Class<? extends Augmentation<OverloadDuration>> augmentationType, Augmentation<OverloadDuration> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OverloadDuration>>, Augmentation<OverloadDuration>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OverloadDurationBuilder removeAugmentation(Class<? extends Augmentation<OverloadDuration>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public OverloadDuration build() {
        return new OverloadDurationImpl(this);
    }

    private static final class OverloadDurationImpl
    extends AbstractAugmentable<OverloadDuration>
    implements OverloadDuration {
        private final Long _duration;
        private int hash = 0;
        private volatile boolean hashValid = false;

        OverloadDurationImpl(OverloadDurationBuilder base) {
            super(base.augmentation);
            this._duration = base.getDuration();
        }

        public Class<OverloadDuration> getImplementedInterface() {
            return OverloadDuration.class;
        }

        @Override
        public Long getDuration() {
            return this._duration;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._duration);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OverloadDuration.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OverloadDuration other = (OverloadDuration)obj;
            if (!Objects.equals(this._duration, other.getDuration())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OverloadDurationImpl otherImpl = (OverloadDurationImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("OverloadDuration");
            CodeHelpers.appendValue(helper, "_duration", this._duration);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

