/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.setup.type.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.setup.type.tlv.PathSetupType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PathSetupTypeBuilder
implements Builder<PathSetupType> {
    private Short _pst;
    Map<Class<? extends Augmentation<PathSetupType>>, Augmentation<PathSetupType>> augmentation = Collections.emptyMap();

    public PathSetupTypeBuilder() {
    }

    public PathSetupTypeBuilder(PathSetupType base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._pst = base.getPst();
    }

    public Short getPst() {
        return this._pst;
    }

    public <E$$ extends Augmentation<PathSetupType>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkPstRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }

    public PathSetupTypeBuilder setPst(Short value) {
        if (value != null) {
            PathSetupTypeBuilder.checkPstRange(value);
        }
        this._pst = value;
        return this;
    }

    public PathSetupTypeBuilder addAugmentation(Class<? extends Augmentation<PathSetupType>> augmentationType, Augmentation<PathSetupType> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathSetupType>>, Augmentation<PathSetupType>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PathSetupTypeBuilder removeAugmentation(Class<? extends Augmentation<PathSetupType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PathSetupType build() {
        return new PathSetupTypeImpl(this);
    }

    private static final class PathSetupTypeImpl
    extends AbstractAugmentable<PathSetupType>
    implements PathSetupType {
        private final Short _pst;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PathSetupTypeImpl(PathSetupTypeBuilder base) {
            super(base.augmentation);
            this._pst = base.getPst();
        }

        public Class<PathSetupType> getImplementedInterface() {
            return PathSetupType.class;
        }

        @Override
        public Short getPst() {
            return this._pst;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._pst);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PathSetupType.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PathSetupType other = (PathSetupType)obj;
            if (!Objects.equals(this._pst, other.getPst())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PathSetupTypeImpl otherImpl = (PathSetupTypeImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PathSetupType");
            CodeHelpers.appendValue(helper, "_pst", this._pst);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

