/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.PcntfMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.Notifications;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcntfMessageBuilder
implements Builder<PcntfMessage> {
    private List<Notifications> _notifications;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>> augmentation = Collections.emptyMap();

    public PcntfMessageBuilder() {
    }

    public PcntfMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public PcntfMessageBuilder(PcntfMessage base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._notifications = base.getNotifications();
        this._version = base.getVersion();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MessageHeader]");
    }

    public List<Notifications> getNotifications() {
        return this._notifications;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E$$ extends Augmentation<PcntfMessage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public PcntfMessageBuilder setNotifications(List<Notifications> values) {
        this._notifications = values;
        return this;
    }

    public PcntfMessageBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public PcntfMessageBuilder addAugmentation(Class<? extends Augmentation<PcntfMessage>> augmentationType, Augmentation<PcntfMessage> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcntfMessageBuilder removeAugmentation(Class<? extends Augmentation<PcntfMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcntfMessage build() {
        return new PcntfMessageImpl(this);
    }

    private static final class PcntfMessageImpl
    extends AbstractAugmentable<PcntfMessage>
    implements PcntfMessage {
        private final List<Notifications> _notifications;
        private final ProtocolVersion _version;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PcntfMessageImpl(PcntfMessageBuilder base) {
            super(base.augmentation);
            this._notifications = base.getNotifications();
            this._version = base.getVersion();
        }

        public Class<PcntfMessage> getImplementedInterface() {
            return PcntfMessage.class;
        }

        @Override
        public List<Notifications> getNotifications() {
            return this._notifications;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._notifications);
            result = 31 * result + Objects.hashCode(this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcntfMessage.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcntfMessage other = (PcntfMessage)obj;
            if (!Objects.equals(this._notifications, other.getNotifications())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcntfMessageImpl otherImpl = (PcntfMessageImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcntfMessage");
            CodeHelpers.appendValue(helper, "_notifications", this._notifications);
            CodeHelpers.appendValue(helper, "_version", this._version);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

