/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.PcrepMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.Replies;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcrepMessageBuilder
implements Builder<PcrepMessage> {
    private List<Replies> _replies;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<PcrepMessage>>, Augmentation<PcrepMessage>> augmentation = Collections.emptyMap();

    public PcrepMessageBuilder() {
    }

    public PcrepMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public PcrepMessageBuilder(PcrepMessage base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._replies = base.getReplies();
        this._version = base.getVersion();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MessageHeader]");
    }

    public List<Replies> getReplies() {
        return this._replies;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E$$ extends Augmentation<PcrepMessage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public PcrepMessageBuilder setReplies(List<Replies> values) {
        this._replies = values;
        return this;
    }

    public PcrepMessageBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public PcrepMessageBuilder addAugmentation(Class<? extends Augmentation<PcrepMessage>> augmentationType, Augmentation<PcrepMessage> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcrepMessage>>, Augmentation<PcrepMessage>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcrepMessageBuilder removeAugmentation(Class<? extends Augmentation<PcrepMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcrepMessage build() {
        return new PcrepMessageImpl(this);
    }

    private static final class PcrepMessageImpl
    extends AbstractAugmentable<PcrepMessage>
    implements PcrepMessage {
        private final List<Replies> _replies;
        private final ProtocolVersion _version;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PcrepMessageImpl(PcrepMessageBuilder base) {
            super(base.augmentation);
            this._replies = base.getReplies();
            this._version = base.getVersion();
        }

        public Class<PcrepMessage> getImplementedInterface() {
            return PcrepMessage.class;
        }

        @Override
        public List<Replies> getReplies() {
            return this._replies;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._replies);
            result = 31 * result + Objects.hashCode(this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcrepMessage.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcrepMessage other = (PcrepMessage)obj;
            if (!Objects.equals(this._replies, other.getReplies())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcrepMessageImpl otherImpl = (PcrepMessageImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcrepMessage");
            CodeHelpers.appendValue(helper, "_replies", this._replies);
            CodeHelpers.appendValue(helper, "_version", this._version);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

