/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.NoPathObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.NoPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.no.path.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NoPathBuilder
implements Builder<NoPath> {
    private Short _natureOfIssue;
    private Tlvs _tlvs;
    private Boolean _ignore;
    private Boolean _processingRule;
    private Boolean _unsatisfiedConstraints;
    Map<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>> augmentation = Collections.emptyMap();

    public NoPathBuilder() {
    }

    public NoPathBuilder(NoPathObject arg) {
        this._natureOfIssue = arg.getNatureOfIssue();
        this._unsatisfiedConstraints = arg.isUnsatisfiedConstraints();
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public NoPathBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public NoPathBuilder(NoPath base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._natureOfIssue = base.getNatureOfIssue();
        this._tlvs = base.getTlvs();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        this._unsatisfiedConstraints = base.isUnsatisfiedConstraints();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof NoPathObject) {
            this._natureOfIssue = ((NoPathObject)arg).getNatureOfIssue();
            this._unsatisfiedConstraints = ((NoPathObject)arg).isUnsatisfiedConstraints();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.NoPathObject]");
    }

    public Short getNatureOfIssue() {
        return this._natureOfIssue;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public Boolean isUnsatisfiedConstraints() {
        return this._unsatisfiedConstraints;
    }

    public <E$$ extends Augmentation<NoPath>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkNatureOfIssueRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }

    public NoPathBuilder setNatureOfIssue(Short value) {
        if (value != null) {
            NoPathBuilder.checkNatureOfIssueRange(value);
        }
        this._natureOfIssue = value;
        return this;
    }

    public NoPathBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public NoPathBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public NoPathBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public NoPathBuilder setUnsatisfiedConstraints(Boolean value) {
        this._unsatisfiedConstraints = value;
        return this;
    }

    public NoPathBuilder addAugmentation(Class<? extends Augmentation<NoPath>> augmentationType, Augmentation<NoPath> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NoPathBuilder removeAugmentation(Class<? extends Augmentation<NoPath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NoPath build() {
        return new NoPathImpl(this);
    }

    private static final class NoPathImpl
    extends AbstractAugmentable<NoPath>
    implements NoPath {
        private final Short _natureOfIssue;
        private final Tlvs _tlvs;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private final Boolean _unsatisfiedConstraints;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NoPathImpl(NoPathBuilder base) {
            super(base.augmentation);
            this._natureOfIssue = base.getNatureOfIssue();
            this._tlvs = base.getTlvs();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            this._unsatisfiedConstraints = base.isUnsatisfiedConstraints();
        }

        public Class<NoPath> getImplementedInterface() {
            return NoPath.class;
        }

        @Override
        public Short getNatureOfIssue() {
            return this._natureOfIssue;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Boolean isUnsatisfiedConstraints() {
            return this._unsatisfiedConstraints;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._natureOfIssue);
            result = 31 * result + Objects.hashCode(this._tlvs);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            result = 31 * result + Objects.hashCode(this._unsatisfiedConstraints);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NoPath.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NoPath other = (NoPath)obj;
            if (!Objects.equals(this._natureOfIssue, other.getNatureOfIssue())) {
                return false;
            }
            if (!Objects.equals(this._tlvs, other.getTlvs())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (!Objects.equals(this._unsatisfiedConstraints, other.isUnsatisfiedConstraints())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NoPathImpl otherImpl = (NoPathImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NoPath");
            CodeHelpers.appendValue(helper, "_natureOfIssue", this._natureOfIssue);
            CodeHelpers.appendValue(helper, "_tlvs", this._tlvs);
            CodeHelpers.appendValue(helper, "_ignore", this._ignore);
            CodeHelpers.appendValue(helper, "_processingRule", this._processingRule);
            CodeHelpers.appendValue(helper, "_unsatisfiedConstraints", this._unsatisfiedConstraints);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

