/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.PcreqMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.MonitoringRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Svec;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcreqMessageBuilder
implements Builder<PcreqMessage> {
    private MonitoringRequest _monitoringRequest;
    private List<Requests> _requests;
    private List<Svec> _svec;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>> augmentation = Collections.emptyMap();

    public PcreqMessageBuilder() {
    }

    public PcreqMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public PcreqMessageBuilder(PcreqMessage base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._monitoringRequest = base.getMonitoringRequest();
        this._requests = base.getRequests();
        this._svec = base.getSvec();
        this._version = base.getVersion();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MessageHeader]");
    }

    public MonitoringRequest getMonitoringRequest() {
        return this._monitoringRequest;
    }

    public List<Requests> getRequests() {
        return this._requests;
    }

    public List<Svec> getSvec() {
        return this._svec;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E$$ extends Augmentation<PcreqMessage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public PcreqMessageBuilder setMonitoringRequest(MonitoringRequest value) {
        this._monitoringRequest = value;
        return this;
    }

    public PcreqMessageBuilder setRequests(List<Requests> values) {
        this._requests = values;
        return this;
    }

    public PcreqMessageBuilder setSvec(List<Svec> values) {
        this._svec = values;
        return this;
    }

    public PcreqMessageBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public PcreqMessageBuilder addAugmentation(Class<? extends Augmentation<PcreqMessage>> augmentationType, Augmentation<PcreqMessage> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcreqMessageBuilder removeAugmentation(Class<? extends Augmentation<PcreqMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcreqMessage build() {
        return new PcreqMessageImpl(this);
    }

    private static final class PcreqMessageImpl
    extends AbstractAugmentable<PcreqMessage>
    implements PcreqMessage {
        private final MonitoringRequest _monitoringRequest;
        private final List<Requests> _requests;
        private final List<Svec> _svec;
        private final ProtocolVersion _version;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PcreqMessageImpl(PcreqMessageBuilder base) {
            super(base.augmentation);
            this._monitoringRequest = base.getMonitoringRequest();
            this._requests = base.getRequests();
            this._svec = base.getSvec();
            this._version = base.getVersion();
        }

        public Class<PcreqMessage> getImplementedInterface() {
            return PcreqMessage.class;
        }

        @Override
        public MonitoringRequest getMonitoringRequest() {
            return this._monitoringRequest;
        }

        @Override
        public List<Requests> getRequests() {
            return this._requests;
        }

        @Override
        public List<Svec> getSvec() {
            return this._svec;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._monitoringRequest);
            result = 31 * result + Objects.hashCode(this._requests);
            result = 31 * result + Objects.hashCode(this._svec);
            result = 31 * result + Objects.hashCode(this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcreqMessage.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcreqMessage other = (PcreqMessage)obj;
            if (!Objects.equals(this._monitoringRequest, other.getMonitoringRequest())) {
                return false;
            }
            if (!Objects.equals(this._requests, other.getRequests())) {
                return false;
            }
            if (!Objects.equals(this._svec, other.getSvec())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcreqMessageImpl otherImpl = (PcreqMessageImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcreqMessage");
            CodeHelpers.appendValue(helper, "_monitoringRequest", this._monitoringRequest);
            CodeHelpers.appendValue(helper, "_requests", this._requests);
            CodeHelpers.appendValue(helper, "_svec", this._svec);
            CodeHelpers.appendValue(helper, "_version", this._version);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

