/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class Nanotime
implements TypeObject,
Serializable {
    private static final long serialVersionUID = 315642407210361354L;
    public static final String _UNITS = "nanoseconds";
    private final BigInteger _value;
    private static final Range<BigInteger>[] CHECK_VALUERANGE_RANGES;

    private static void check_valueRange(BigInteger value) {
        for (Range<BigInteger> r : CHECK_VALUERANGE_RANGES) {
            if (!r.contains(value)) continue;
            return;
        }
        CodeHelpers.throwInvalidRange(CHECK_VALUERANGE_RANGES, (Object)value);
    }

    @ConstructorProperties(value={"value"})
    public Nanotime(BigInteger _value) {
        if (_value != null) {
            Nanotime.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public Nanotime(Nanotime source) {
        this._value = source._value;
    }

    public static Nanotime getDefaultInstance(String defaultValue) {
        return new Nanotime(new BigInteger(defaultValue));
    }

    public BigInteger getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Nanotime other = (Nanotime)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Nanotime.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        CodeHelpers.appendValue(helper, "_UNITS", _UNITS);
        return helper.toString();
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed(BigInteger.ZERO, new BigInteger("18446744073709551615"));
        CHECK_VALUERANGE_RANGES = a;
    }
}

