/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue.InstructionKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InstructionBuilder
implements Builder<Instruction> {
    private Nanotime _deadline;
    private InstructionId _id;
    private InstructionStatus _status;
    private InstructionKey key;
    Map<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>> augmentation = Collections.emptyMap();

    public InstructionBuilder() {
    }

    public InstructionBuilder(Instruction base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this.key = base.key();
        this._id = base.getId();
        this._deadline = base.getDeadline();
        this._status = base.getStatus();
    }

    public InstructionKey key() {
        return this.key;
    }

    public Nanotime getDeadline() {
        return this._deadline;
    }

    public InstructionId getId() {
        return this._id;
    }

    public InstructionStatus getStatus() {
        return this._status;
    }

    public <E$$ extends Augmentation<Instruction>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public InstructionBuilder withKey(InstructionKey key) {
        this.key = key;
        return this;
    }

    public InstructionBuilder setDeadline(Nanotime value) {
        this._deadline = value;
        return this;
    }

    public InstructionBuilder setId(InstructionId value) {
        this._id = value;
        return this;
    }

    public InstructionBuilder setStatus(InstructionStatus value) {
        this._status = value;
        return this;
    }

    public InstructionBuilder addAugmentation(Class<? extends Augmentation<Instruction>> augmentationType, Augmentation<Instruction> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InstructionBuilder removeAugmentation(Class<? extends Augmentation<Instruction>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Instruction build() {
        return new InstructionImpl(this);
    }

    private static final class InstructionImpl
    extends AbstractAugmentable<Instruction>
    implements Instruction {
        private final Nanotime _deadline;
        private final InstructionId _id;
        private final InstructionStatus _status;
        private final InstructionKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        InstructionImpl(InstructionBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new InstructionKey(base.getId());
            this._id = this.key.getId();
            this._deadline = base.getDeadline();
            this._status = base.getStatus();
        }

        public Class<Instruction> getImplementedInterface() {
            return Instruction.class;
        }

        @Override
        public InstructionKey key() {
            return this.key;
        }

        @Override
        public Nanotime getDeadline() {
            return this._deadline;
        }

        @Override
        public InstructionId getId() {
            return this._id;
        }

        @Override
        public InstructionStatus getStatus() {
            return this._status;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._deadline);
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._status);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Instruction.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Instruction other = (Instruction)obj;
            if (!Objects.equals(this._deadline, other.getDeadline())) {
                return false;
            }
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._status, other.getStatus())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InstructionImpl otherImpl = (InstructionImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Instruction");
            CodeHelpers.appendValue(helper, "_deadline", this._deadline);
            CodeHelpers.appendValue(helper, "_id", this._id);
            CodeHelpers.appendValue(helper, "_status", this._status);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

