/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class PceId
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -3775655423512102136L;
    private final byte[] _value;

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length == 4) {
            return;
        }
        if (length == 16) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[4..4], [16..16]]", value);
    }

    @ConstructorProperties(value={"value"})
    public PceId(byte[] _value) {
        if (_value != null) {
            PceId.check_valueLength(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = (byte[])_value.clone();
    }

    public PceId(PceId source) {
        this._value = source._value;
    }

    public static PceId getDefaultInstance(String defaultValue) {
        return new PceId(Base64.getDecoder().decode(defaultValue));
    }

    public byte[] getValue() {
        return this._value == null ? null : (byte[])this._value.clone();
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PceId other = (PceId)obj;
        return Arrays.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(PceId.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

