/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.attribute.flags;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.attribute.flags.FlagContainer;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlagContainerBuilder
implements Builder<FlagContainer> {
    private byte[] _flags;
    Map<Class<? extends Augmentation<FlagContainer>>, Augmentation<FlagContainer>> augmentation = Collections.emptyMap();

    public FlagContainerBuilder() {
    }

    public FlagContainerBuilder(FlagContainer base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._flags = base.getFlags();
    }

    public byte[] getFlags() {
        return this._flags == null ? null : (byte[])this._flags.clone();
    }

    public <E$$ extends Augmentation<FlagContainer>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void check_flagsLength(byte[] value) {
        int length = value.length;
        if (length == 4) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[4..4]]", value);
    }

    public FlagContainerBuilder setFlags(byte[] value) {
        if (value != null) {
            FlagContainerBuilder.check_flagsLength(value);
        }
        this._flags = value;
        return this;
    }

    public FlagContainerBuilder addAugmentation(Class<? extends Augmentation<FlagContainer>> augmentationType, Augmentation<FlagContainer> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlagContainer>>, Augmentation<FlagContainer>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public FlagContainerBuilder removeAugmentation(Class<? extends Augmentation<FlagContainer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlagContainer build() {
        return new FlagContainerImpl(this);
    }

    private static final class FlagContainerImpl
    extends AbstractAugmentable<FlagContainer>
    implements FlagContainer {
        private final byte[] _flags;
        private int hash = 0;
        private volatile boolean hashValid = false;

        FlagContainerImpl(FlagContainerBuilder base) {
            super(base.augmentation);
            this._flags = base.getFlags();
        }

        public Class<FlagContainer> getImplementedInterface() {
            return FlagContainer.class;
        }

        @Override
        public byte[] getFlags() {
            return this._flags == null ? null : (byte[])this._flags.clone();
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this._flags);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlagContainer.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlagContainer other = (FlagContainer)obj;
            if (!Arrays.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlagContainerImpl otherImpl = (FlagContainerImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlagContainer");
            CodeHelpers.appendValue(helper, "_flags", this._flags);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

