/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.fast.reroute.object.fast.reroute.object.basic.fast.reroute.object._case;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.CommonFastRerouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.FastRerouteFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.fast.reroute.object.fast.reroute.object.basic.fast.reroute.object._case.BasicFastRerouteObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BasicFastRerouteObjectBuilder
implements Builder<BasicFastRerouteObject> {
    private Bandwidth _bandwidth;
    private AttributeFilter _excludeAny;
    private FastRerouteFlags _flags;
    private Short _holdPriority;
    private Short _hopLimit;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private Short _setupPriority;
    Map<Class<? extends Augmentation<BasicFastRerouteObject>>, Augmentation<BasicFastRerouteObject>> augmentation = Collections.emptyMap();

    public BasicFastRerouteObjectBuilder() {
    }

    public BasicFastRerouteObjectBuilder(CommonFastRerouteObject arg) {
        this._hopLimit = arg.getHopLimit();
        this._flags = arg.getFlags();
        this._bandwidth = arg.getBandwidth();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public BasicFastRerouteObjectBuilder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }

    public BasicFastRerouteObjectBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public BasicFastRerouteObjectBuilder(BasicFastRerouteObject base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._bandwidth = base.getBandwidth();
        this._excludeAny = base.getExcludeAny();
        this._flags = base.getFlags();
        this._holdPriority = base.getHoldPriority();
        this._hopLimit = base.getHopLimit();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._setupPriority = base.getSetupPriority();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonFastRerouteObject) {
            this._hopLimit = ((CommonFastRerouteObject)arg).getHopLimit();
            this._flags = ((CommonFastRerouteObject)arg).getFlags();
            this._bandwidth = ((CommonFastRerouteObject)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof Priority) {
            this._holdPriority = ((Priority)arg).getHoldPriority();
            this._setupPriority = ((Priority)arg).getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters) {
            this._includeAny = ((AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.CommonFastRerouteObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters]");
    }

    public Bandwidth getBandwidth() {
        return this._bandwidth;
    }

    public AttributeFilter getExcludeAny() {
        return this._excludeAny;
    }

    public FastRerouteFlags getFlags() {
        return this._flags;
    }

    public Short getHoldPriority() {
        return this._holdPriority;
    }

    public Short getHopLimit() {
        return this._hopLimit;
    }

    public AttributeFilter getIncludeAll() {
        return this._includeAll;
    }

    public AttributeFilter getIncludeAny() {
        return this._includeAny;
    }

    public Short getSetupPriority() {
        return this._setupPriority;
    }

    public <E$$ extends Augmentation<BasicFastRerouteObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public BasicFastRerouteObjectBuilder setBandwidth(Bandwidth value) {
        this._bandwidth = value;
        return this;
    }

    public BasicFastRerouteObjectBuilder setExcludeAny(AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }

    public BasicFastRerouteObjectBuilder setFlags(FastRerouteFlags value) {
        this._flags = value;
        return this;
    }

    private static void checkHoldPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }

    public BasicFastRerouteObjectBuilder setHoldPriority(Short value) {
        if (value != null) {
            BasicFastRerouteObjectBuilder.checkHoldPriorityRange(value);
        }
        this._holdPriority = value;
        return this;
    }

    private static void checkHopLimitRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }

    public BasicFastRerouteObjectBuilder setHopLimit(Short value) {
        if (value != null) {
            BasicFastRerouteObjectBuilder.checkHopLimitRange(value);
        }
        this._hopLimit = value;
        return this;
    }

    public BasicFastRerouteObjectBuilder setIncludeAll(AttributeFilter value) {
        this._includeAll = value;
        return this;
    }

    public BasicFastRerouteObjectBuilder setIncludeAny(AttributeFilter value) {
        this._includeAny = value;
        return this;
    }

    private static void checkSetupPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }

    public BasicFastRerouteObjectBuilder setSetupPriority(Short value) {
        if (value != null) {
            BasicFastRerouteObjectBuilder.checkSetupPriorityRange(value);
        }
        this._setupPriority = value;
        return this;
    }

    public BasicFastRerouteObjectBuilder addAugmentation(Class<? extends Augmentation<BasicFastRerouteObject>> augmentationType, Augmentation<BasicFastRerouteObject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BasicFastRerouteObject>>, Augmentation<BasicFastRerouteObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public BasicFastRerouteObjectBuilder removeAugmentation(Class<? extends Augmentation<BasicFastRerouteObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public BasicFastRerouteObject build() {
        return new BasicFastRerouteObjectImpl(this);
    }

    private static final class BasicFastRerouteObjectImpl
    extends AbstractAugmentable<BasicFastRerouteObject>
    implements BasicFastRerouteObject {
        private final Bandwidth _bandwidth;
        private final AttributeFilter _excludeAny;
        private final FastRerouteFlags _flags;
        private final Short _holdPriority;
        private final Short _hopLimit;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final Short _setupPriority;
        private int hash = 0;
        private volatile boolean hashValid = false;

        BasicFastRerouteObjectImpl(BasicFastRerouteObjectBuilder base) {
            super(base.augmentation);
            this._bandwidth = base.getBandwidth();
            this._excludeAny = base.getExcludeAny();
            this._flags = base.getFlags();
            this._holdPriority = base.getHoldPriority();
            this._hopLimit = base.getHopLimit();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._setupPriority = base.getSetupPriority();
        }

        public Class<BasicFastRerouteObject> getImplementedInterface() {
            return BasicFastRerouteObject.class;
        }

        @Override
        public Bandwidth getBandwidth() {
            return this._bandwidth;
        }

        @Override
        public AttributeFilter getExcludeAny() {
            return this._excludeAny;
        }

        @Override
        public FastRerouteFlags getFlags() {
            return this._flags;
        }

        @Override
        public Short getHoldPriority() {
            return this._holdPriority;
        }

        @Override
        public Short getHopLimit() {
            return this._hopLimit;
        }

        @Override
        public AttributeFilter getIncludeAll() {
            return this._includeAll;
        }

        @Override
        public AttributeFilter getIncludeAny() {
            return this._includeAny;
        }

        @Override
        public Short getSetupPriority() {
            return this._setupPriority;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bandwidth);
            result = 31 * result + Objects.hashCode(this._excludeAny);
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._holdPriority);
            result = 31 * result + Objects.hashCode(this._hopLimit);
            result = 31 * result + Objects.hashCode(this._includeAll);
            result = 31 * result + Objects.hashCode(this._includeAny);
            result = 31 * result + Objects.hashCode(this._setupPriority);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BasicFastRerouteObject.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BasicFastRerouteObject other = (BasicFastRerouteObject)obj;
            if (!Objects.equals(this._bandwidth, other.getBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._excludeAny, other.getExcludeAny())) {
                return false;
            }
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._holdPriority, other.getHoldPriority())) {
                return false;
            }
            if (!Objects.equals(this._hopLimit, other.getHopLimit())) {
                return false;
            }
            if (!Objects.equals(this._includeAll, other.getIncludeAll())) {
                return false;
            }
            if (!Objects.equals(this._includeAny, other.getIncludeAny())) {
                return false;
            }
            if (!Objects.equals(this._setupPriority, other.getSetupPriority())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BasicFastRerouteObjectImpl otherImpl = (BasicFastRerouteObjectImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("BasicFastRerouteObject");
            CodeHelpers.appendValue(helper, "_bandwidth", this._bandwidth);
            CodeHelpers.appendValue(helper, "_excludeAny", this._excludeAny);
            CodeHelpers.appendValue(helper, "_flags", this._flags);
            CodeHelpers.appendValue(helper, "_holdPriority", this._holdPriority);
            CodeHelpers.appendValue(helper, "_hopLimit", this._hopLimit);
            CodeHelpers.appendValue(helper, "_includeAll", this._includeAll);
            CodeHelpers.appendValue(helper, "_includeAny", this._includeAny);
            CodeHelpers.appendValue(helper, "_setupPriority", this._setupPriority);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

