/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.TpReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input.Destination;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DestinationBuilder
implements Builder<Destination> {
    private NodeId _node;
    private TpId _tp;
    Map<Class<? extends Augmentation<Destination>>, Augmentation<Destination>> augmentation = Collections.emptyMap();

    public DestinationBuilder() {
    }

    public DestinationBuilder(TpReference arg) {
        this._node = arg.getNode();
        this._tp = arg.getTp();
    }

    public DestinationBuilder(Destination base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._node = base.getNode();
        this._tp = base.getTp();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TpReference) {
            this._node = ((TpReference)arg).getNode();
            this._tp = ((TpReference)arg).getTp();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.TpReference]");
    }

    public NodeId getNode() {
        return this._node;
    }

    public TpId getTp() {
        return this._tp;
    }

    public <E$$ extends Augmentation<Destination>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public DestinationBuilder setNode(NodeId value) {
        this._node = value;
        return this;
    }

    public DestinationBuilder setTp(TpId value) {
        this._tp = value;
        return this;
    }

    public DestinationBuilder addAugmentation(Class<? extends Augmentation<Destination>> augmentationType, Augmentation<Destination> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Destination>>, Augmentation<Destination>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DestinationBuilder removeAugmentation(Class<? extends Augmentation<Destination>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Destination build() {
        return new DestinationImpl(this);
    }

    private static final class DestinationImpl
    extends AbstractAugmentable<Destination>
    implements Destination {
        private final NodeId _node;
        private final TpId _tp;
        private int hash = 0;
        private volatile boolean hashValid = false;

        DestinationImpl(DestinationBuilder base) {
            super(base.augmentation);
            this._node = base.getNode();
            this._tp = base.getTp();
        }

        public Class<Destination> getImplementedInterface() {
            return Destination.class;
        }

        @Override
        public NodeId getNode() {
            return this._node;
        }

        @Override
        public TpId getTp() {
            return this._tp;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._tp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Destination.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Destination other = (Destination)obj;
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._tp, other.getTp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DestinationImpl otherImpl = (DestinationImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Destination");
            CodeHelpers.appendValue(helper, "_node", this._node);
            CodeHelpers.appendValue(helper, "_tp", this._tp);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

