/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.rev130819.network.topology.topology;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.rev130819.PathId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.rev130819.network.topology.topology.Paths;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.rev130819.network.topology.topology.PathsKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.rev130819.network.topology.topology.paths.PathTypes;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PathsBuilder
implements Builder<Paths> {
    private PathId _pathId;
    private PathTypes _pathTypes;
    private PathsKey key;
    Map<Class<? extends Augmentation<Paths>>, Augmentation<Paths>> augmentation = Collections.emptyMap();

    public PathsBuilder() {
    }

    public PathsBuilder(Paths base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this.key = base.key();
        this._pathId = base.getPathId();
        this._pathTypes = base.getPathTypes();
    }

    public PathsKey key() {
        return this.key;
    }

    public PathId getPathId() {
        return this._pathId;
    }

    public PathTypes getPathTypes() {
        return this._pathTypes;
    }

    public <E$$ extends Augmentation<Paths>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public PathsBuilder withKey(PathsKey key) {
        this.key = key;
        return this;
    }

    public PathsBuilder setPathId(PathId value) {
        this._pathId = value;
        return this;
    }

    public PathsBuilder setPathTypes(PathTypes value) {
        this._pathTypes = value;
        return this;
    }

    public PathsBuilder addAugmentation(Class<? extends Augmentation<Paths>> augmentationType, Augmentation<Paths> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Paths>>, Augmentation<Paths>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PathsBuilder removeAugmentation(Class<? extends Augmentation<Paths>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Paths build() {
        return new PathsImpl(this);
    }

    private static final class PathsImpl
    extends AbstractAugmentable<Paths>
    implements Paths {
        private final PathId _pathId;
        private final PathTypes _pathTypes;
        private final PathsKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PathsImpl(PathsBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new PathsKey(base.getPathId());
            this._pathId = this.key.getPathId();
            this._pathTypes = base.getPathTypes();
        }

        public Class<Paths> getImplementedInterface() {
            return Paths.class;
        }

        @Override
        public PathsKey key() {
            return this.key;
        }

        @Override
        public PathId getPathId() {
            return this._pathId;
        }

        @Override
        public PathTypes getPathTypes() {
            return this._pathTypes;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._pathId);
            result = 31 * result + Objects.hashCode(this._pathTypes);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Paths.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Paths other = (Paths)obj;
            if (!Objects.equals(this._pathId, other.getPathId())) {
                return false;
            }
            if (!Objects.equals(this._pathTypes, other.getPathTypes())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PathsImpl otherImpl = (PathsImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Paths");
            CodeHelpers.appendValue(helper, "_pathId", this._pathId);
            CodeHelpers.appendValue(helper, "_pathTypes", this._pathTypes);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

