/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.SupportingLink;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.SupportingLinkKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SupportingLinkBuilder
implements Builder<SupportingLink> {
    private LinkId _linkRef;
    private SupportingLinkKey key;
    Map<Class<? extends Augmentation<SupportingLink>>, Augmentation<SupportingLink>> augmentation = Collections.emptyMap();

    public SupportingLinkBuilder() {
    }

    public SupportingLinkBuilder(SupportingLink base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this.key = base.key();
        this._linkRef = base.getLinkRef();
    }

    public SupportingLinkKey key() {
        return this.key;
    }

    public LinkId getLinkRef() {
        return this._linkRef;
    }

    public <E$$ extends Augmentation<SupportingLink>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public SupportingLinkBuilder withKey(SupportingLinkKey key) {
        this.key = key;
        return this;
    }

    public SupportingLinkBuilder setLinkRef(LinkId value) {
        this._linkRef = value;
        return this;
    }

    public SupportingLinkBuilder addAugmentation(Class<? extends Augmentation<SupportingLink>> augmentationType, Augmentation<SupportingLink> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportingLink>>, Augmentation<SupportingLink>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SupportingLinkBuilder removeAugmentation(Class<? extends Augmentation<SupportingLink>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SupportingLink build() {
        return new SupportingLinkImpl(this);
    }

    private static final class SupportingLinkImpl
    extends AbstractAugmentable<SupportingLink>
    implements SupportingLink {
        private final LinkId _linkRef;
        private final SupportingLinkKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SupportingLinkImpl(SupportingLinkBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new SupportingLinkKey(base.getLinkRef());
            this._linkRef = this.key.getLinkRef();
        }

        public Class<SupportingLink> getImplementedInterface() {
            return SupportingLink.class;
        }

        @Override
        public SupportingLinkKey key() {
            return this.key;
        }

        @Override
        public LinkId getLinkRef() {
            return this._linkRef;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._linkRef);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SupportingLink.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SupportingLink other = (SupportingLink)obj;
            if (!Objects.equals(this._linkRef, other.getLinkRef())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SupportingLinkImpl otherImpl = (SupportingLinkImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SupportingLink");
            CodeHelpers.appendValue(helper, "_linkRef", this._linkRef);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

