/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class OffsetMapCache {
    private static final LoadingCache<List<?>, ImmutableMap<?, Integer>> ORDERED_CACHE = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<List<?>, ImmutableMap<?, Integer>>(){

        @Override
        public ImmutableMap<?, Integer> load(List<?> key) {
            return OffsetMapCache.createMap(key);
        }
    });
    private static final Cache<Set<?>, ImmutableMap<?, Integer>> UNORDERED_CACHE = CacheBuilder.newBuilder().weakValues().build();

    private OffsetMapCache() {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    static void invalidateCache() {
        ORDERED_CACHE.invalidateAll();
        UNORDERED_CACHE.invalidateAll();
    }

    static <T> ImmutableMap<T, Integer> orderedOffsets(Collection<T> args) {
        if (args.size() == 1) {
            return OffsetMapCache.unorderedOffsets(args);
        }
        return ORDERED_CACHE.getUnchecked(ImmutableList.copyOf(args));
    }

    static <T> ImmutableMap<T, Integer> unorderedOffsets(Collection<T> args) {
        return OffsetMapCache.unorderedOffsets(args instanceof Set ? (ImmutableSet<T>)args : ImmutableSet.copyOf(args));
    }

    private static <T> ImmutableMap<T, Integer> unorderedOffsets(Set<T> args) {
        ImmutableMap<?, Integer> existing = UNORDERED_CACHE.getIfPresent(args);
        if (existing != null) {
            return existing;
        }
        ImmutableMap<T, Integer> newMap = OffsetMapCache.createMap(args);
        ImmutableMap<T, Integer> raced = UNORDERED_CACHE.asMap().putIfAbsent(newMap.keySet(), newMap);
        return raced == null ? newMap : raced;
    }

    static <K, V> V[] adjustedArray(Map<K, Integer> offsets, List<K> keys, V[] array) {
        Verify.verify(offsets.size() == keys.size(), "Offsets %s do not match keys %s", offsets, keys);
        Iterator<K> oi = offsets.keySet().iterator();
        Iterator<K> ki = keys.iterator();
        while (oi.hasNext()) {
            K o = oi.next();
            K k = ki.next();
            if (k.equals(o)) continue;
            return OffsetMapCache.adjustArray(offsets, keys, array);
        }
        return array;
    }

    private static <T> ImmutableMap<T, Integer> createMap(Collection<T> keys) {
        ImmutableMap.Builder<T, Integer> b = ImmutableMap.builder();
        int counter = 0;
        for (T arg : keys) {
            b.put(arg, counter++);
        }
        return b.build();
    }

    private static <K, V> V[] adjustArray(Map<K, Integer> offsets, List<K> keys, V[] array) {
        Object[] ret = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length);
        int offset = 0;
        for (K k : keys) {
            Integer o = Verify.verifyNotNull(offsets.get(k), "Key %s not present in offsets %s", k, offsets);
            ret[o.intValue()] = array[offset++];
        }
        return ret;
    }
}

