/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.collect.ForwardingMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.opendaylight.yangtools.util.ReadWriteTrieMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.MutableTrieMap;

final class ReadOnlyTrieMap<K, V>
extends ForwardingMap<K, V> {
    private static final AtomicReferenceFieldUpdater<ReadOnlyTrieMap, ImmutableTrieMap> UPDATER = AtomicReferenceFieldUpdater.newUpdater(ReadOnlyTrieMap.class, ImmutableTrieMap.class, "readOnly");
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyTrieMap.class);
    private final MutableTrieMap<K, V> readWrite;
    private final int size;
    private volatile ImmutableTrieMap<K, V> readOnly;

    ReadOnlyTrieMap(MutableTrieMap<K, V> map, int size) {
        this.readWrite = Objects.requireNonNull(map);
        this.size = size;
    }

    Map<K, V> toReadWrite() {
        ReadWriteTrieMap<K, V> ret = new ReadWriteTrieMap<K, V>(this.readWrite.mutableSnapshot(), this.size);
        LOG.trace("Converted read-only TrieMap {} to read-write {}", (Object)this, (Object)ret);
        return ret;
    }

    @Override
    protected Map<K, V> delegate() {
        ImmutableTrieMap<K, V> ret = this.readOnly;
        if (ret == null && !UPDATER.compareAndSet(this, null, ret = this.readWrite.immutableSnapshot())) {
            ret = this.readOnly;
        }
        return ret;
    }

    @Override
    public int size() {
        return this.size;
    }
}

