/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.immutables.value.Value;
import org.opendaylight.yangtools.util.concurrent.ImmutableThreadFactoryProvider;
import org.slf4j.Logger;

@Value.Immutable
@Value.Style(stagedBuilder=true, allowedClasspathAnnotations={Override.class, SuppressWarnings.class, SuppressFBWarnings.class, NotThreadSafe.class, Immutable.class, Generated.class})
public abstract class ThreadFactoryProvider {
    public static ImmutableThreadFactoryProvider.NamePrefixBuildStage builder() {
        return ImmutableThreadFactoryProvider.builder();
    }

    @Value.Parameter
    public abstract String namePrefix();

    @Value.Parameter
    public abstract Logger logger();

    @Value.Parameter
    public abstract Optional<Integer> priority();

    @Value.Default
    public boolean daemon() {
        return true;
    }

    public ThreadFactory get() {
        ThreadFactoryBuilder guavaBuilder = new ThreadFactoryBuilder().setNameFormat(this.namePrefix() + "-%d").setUncaughtExceptionHandler((thread, exception) -> this.logger().error("Thread terminated due to uncaught exception: {}", (Object)thread.getName(), (Object)exception)).setDaemon(this.daemon());
        this.priority().ifPresent(guavaBuilder::setPriority);
        this.logger().info("ThreadFactory created: {}", (Object)this.namePrefix());
        return guavaBuilder.build();
    }
}

