/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.WritableObject;

@Beta
@NonNullByDefault
public abstract class AbstractQName
implements Identifier,
WritableObject {
    private static final long serialVersionUID = 1L;
    private static final CharMatcher IDENTIFIER_START = CharMatcher.inRange('A', 'Z').or(CharMatcher.inRange('a', 'z').or(CharMatcher.is('_'))).precomputed();
    private static final CharMatcher NOT_IDENTIFIER_PART = IDENTIFIER_START.or(CharMatcher.inRange('0', '9')).or(CharMatcher.anyOf("-.")).negate().precomputed();
    private final String localName;

    AbstractQName(String localName) {
        this.localName = Objects.requireNonNull(localName);
    }

    public final String getLocalName() {
        return this.localName;
    }

    public abstract AbstractQName intern();

    @Override
    public abstract int hashCode();

    @Override
    public abstract boolean equals(@Nullable Object var1);

    @Override
    public abstract String toString();

    abstract Object writeReplace();

    static final String checkLocalName(@Nullable String localName) {
        Preconditions.checkArgument(localName != null, "Parameter 'localName' may not be null.");
        Preconditions.checkArgument(!localName.isEmpty(), "Parameter 'localName' must be a non-empty string.");
        Preconditions.checkArgument(IDENTIFIER_START.matches(localName.charAt(0)) && NOT_IDENTIFIER_PART.indexIn(localName, 1) == -1, "String '%s' is not a valid identifier", (Object)localName);
        return localName;
    }
}

